/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.github.benmanes.caffeine.cache.Cache;
import carbonchat.libs.com.github.benmanes.caffeine.cache.Caffeine;
import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.InvalidatePartyInvitePacket;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.messaging.packets.PartyInvitePacket;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.kyori.adventure.audience.Audience;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class PartyInvites {
    private final Map<UUID, Cache<UUID, UUID>> pendingInvites = new ConcurrentHashMap<UUID, Cache<UUID, UUID>>();
    private final Provider<MessagingManager> messaging;
    private final PacketFactory packetFactory;
    private final UserManagerInternal<?> users;
    private final Logger logger;
    private final CarbonMessages messages;
    private final ConfigManager config;

    @Inject
    private PartyInvites(Provider<MessagingManager> messaging, PacketFactory packetFactory, UserManagerInternal<?> users, Logger logger, CarbonMessages messages, ConfigManager config) {
        this.messaging = messaging;
        this.packetFactory = packetFactory;
        this.users = users;
        this.logger = logger;
        this.messages = messages;
        this.config = config;
    }

    public void sendInvite(UUID from, UUID to, UUID party) {
        Cache<UUID, UUID> cache = this.orCreateInvitesFor(to);
        cache.put((Object)from, (Object)party);
        this.clean();
        ((MessagingManager)this.messaging.get()).queuePacket(() -> this.packetFactory.partyInvite(from, to, party));
    }

    public void invalidateInvite(UUID from, UUID to) {
        this.invalidateInvite_(from, to);
        ((MessagingManager)this.messaging.get()).queuePacket(() -> this.packetFactory.invalidatePartyInvite(from, to));
    }

    private void invalidateInvite_(UUID from, UUID to) {
        @Nullable Cache<UUID, UUID> cache = this.invitesFor(to);
        if (cache != null) {
            cache.invalidate((Object)from);
        }
        this.clean();
    }

    public @Nullable Cache<UUID, UUID> invitesFor(UUID recipient) {
        return this.pendingInvites.get(recipient);
    }

    private Cache<UUID, UUID> orCreateInvitesFor(UUID recipient) {
        return this.pendingInvites.computeIfAbsent(recipient, $ -> this.makeCache());
    }

    private Cache<UUID, UUID> makeCache() {
        return Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(this.config.primaryConfig().partyChat().expireInvitesAfterSeconds)).build();
    }

    public void handle(InvalidatePartyInvitePacket pkt) {
        this.invalidateInvite_(pkt.from(), pkt.to());
        this.clean();
    }

    private void clean() {
        this.pendingInvites.values().removeIf(it -> it.asMap().size() == 0);
    }

    public void handle(PartyInvitePacket pkt) {
        @Nullable Cache<UUID, UUID> cache = this.orCreateInvitesFor(pkt.to());
        cache.put((Object)pkt.from(), (Object)pkt.party());
        this.clean();
        CompletableFuture to = this.users.user(pkt.to());
        CompletableFuture from = this.users.user(pkt.to());
        CompletableFuture<Party> party = this.users.party(pkt.party());
        ((CompletableFuture)CompletableFuture.allOf(to, from, party).thenRun(() -> {
            if (((CarbonPlayer)to.join()).online()) {
                this.messages.receivedPartyInvite((Audience)to.join(), ((CarbonPlayer)from.join()).displayName(), ((CarbonPlayer)from.join()).username(), ((Party)party.join()).name());
            }
        })).whenComplete(($, thr) -> {
            if (thr != null) {
                this.logger.warn("Exception handling {}", (Object)pkt, thr);
            }
        });
    }
}

