/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;

@DefaultQualifier(value=NonNull.class)
public final class PersistentUserProperty<T> {
    private final AtomicReference<@Nullable T> valueReference;
    private final List<Runnable> updateListeners = new CopyOnWriteArrayList<Runnable>();
    private volatile boolean changed = false;

    public PersistentUserProperty(@Nullable T value) {
        this.valueReference = new AtomicReference<T>(value);
    }

    @ApiStatus.Internal
    public void internalSet(@Nullable T value) {
        this.valueReference.set(value);
    }

    public void set(@Nullable T value) {
        @Nullable T old = this.valueReference.getAndSet(value);
        if (Objects.equals(value, old)) {
            return;
        }
        this.changed = true;
        for (Runnable updateListener : this.updateListeners) {
            updateListener.run();
        }
    }

    public void saved() {
        this.changed = false;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.updateListeners.add(runnable);
    }

    public T get() {
        return Objects.requireNonNull(this.valueReference.get(), "value required but not present");
    }

    public boolean hasValue() {
        return this.valueReference.get() != null;
    }

    public @Nullable T orNull() {
        return this.valueReference.get();
    }

    public boolean changed() {
        return this.changed;
    }

    public static <T> PersistentUserProperty<T> of(@Nullable T value) {
        return new PersistentUserProperty<T>(value);
    }

    public static <T> PersistentUserProperty<T> empty() {
        return new PersistentUserProperty<Object>(null);
    }

    public static final class Serializer
    implements JsonSerializer<PersistentUserProperty<?>>,
    JsonDeserializer<PersistentUserProperty<?>> {
        public PersistentUserProperty<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Type propType = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
            return new PersistentUserProperty<Object>(context.deserialize(json, propType));
        }

        public JsonElement serialize(PersistentUserProperty<?> src, Type typeOfSrc, JsonSerializationContext context) {
            Type propType = ((ParameterizedType)typeOfSrc).getActualTypeArguments()[0];
            return context.serialize(src.orNull(), propType);
        }
    }
}

