/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Module;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.com.google.inject.assistedinject.FactoryModuleBuilder;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.common.messaging.packets.DisbandPartyPacket;
import net.draycia.carbon.common.messaging.packets.PartyChangePacket;
import net.draycia.carbon.common.users.Backing;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.PartyImpl;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.kyori.adventure.text.Component;

@Singleton
@DefaultQualifier(value=NonNull.class)
public final class PlatformUserManager
implements UserManagerInternal<WrappedCarbonPlayer> {
    private final UserManagerInternal<CarbonPlayerCommon> backingManager;
    private final PlayerFactory playerFactory;
    private final Injector injector;

    @Inject
    private PlatformUserManager(@Backing UserManagerInternal<CarbonPlayerCommon> backingManager, PlayerFactory playerFactory, Injector injector) {
        this.backingManager = backingManager;
        this.playerFactory = playerFactory;
        this.injector = injector;
    }

    @Override
    public CompletableFuture<WrappedCarbonPlayer> user(UUID uuid) {
        return this.backingManager.user(uuid).thenApply(common -> {
            WrappedCarbonPlayer wrapped = this.playerFactory.wrap((CarbonPlayerCommon)common);
            common.markTransientLoaded(!wrapped.online());
            return wrapped;
        });
    }

    @Override
    public Party createParty(Component name) {
        PartyImpl party = PartyImpl.create(name);
        this.injector.injectMembers((Object)party);
        return party;
    }

    @Override
    public void shutdown() {
        this.backingManager.shutdown();
    }

    @Override
    public void saveCompleteMessageReceived(UUID playerId) {
        this.backingManager.saveCompleteMessageReceived(playerId);
    }

    @Override
    public CompletableFuture<Void> saveIfNeeded(WrappedCarbonPlayer player) {
        return this.backingManager.saveIfNeeded(player.carbonPlayerCommon());
    }

    @Override
    public CompletableFuture<Void> loggedOut(UUID uuid) {
        return this.backingManager.loggedOut(uuid);
    }

    @Override
    public void cleanup() {
        this.backingManager.cleanup();
    }

    @Override
    public CompletableFuture<@Nullable Party> party(UUID id) {
        return this.backingManager.party(id);
    }

    @Override
    public CompletableFuture<Void> saveParty(PartyImpl info) {
        return this.backingManager.saveParty(info);
    }

    @Override
    public void disbandParty(UUID id) {
        this.backingManager.disbandParty(id);
    }

    @Override
    public void partyChangeMessageReceived(PartyChangePacket pkt) {
        this.backingManager.partyChangeMessageReceived(pkt);
    }

    @Override
    public void disbandPartyMessageReceived(DisbandPartyPacket pkt) {
        this.backingManager.disbandPartyMessageReceived(pkt);
    }

    public static interface PlayerFactory {
        public WrappedCarbonPlayer wrap(CarbonPlayerCommon var1);

        public static Module moduleFor(Class<? extends WrappedCarbonPlayer> carbonPlayerImpl) {
            return new FactoryModuleBuilder().implement(WrappedCarbonPlayer.class, carbonPlayerImpl).build(PlayerFactory.class);
        }
    }
}

