/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class PlayerUtils {
    private PlayerUtils() {
    }

    public static <C extends CarbonPlayer> List<CompletableFuture<Void>> saveLoggedInPlayers(CarbonServer carbonServer, UserManagerInternal<C> userManager, Logger logger) {
        return carbonServer.players().stream().map(player -> PlayerUtils.savePlayer(userManager, player, logger)).toList();
    }

    private static <C extends CarbonPlayer> CompletableFuture<Void> savePlayer(UserManagerInternal<C> userManager, C player, Logger logger) {
        CarbonPlayerCommon common;
        CompletableFuture<Void> saveResult = userManager.saveIfNeeded(player);
        if (player instanceof WrappedCarbonPlayer) {
            WrappedCarbonPlayer wrapped = (WrappedCarbonPlayer)player;
            v0 = wrapped.carbonPlayerCommon();
        } else {
            v0 = common = null;
        }
        if (common == null) {
            throw new IllegalStateException("Failed to unwrap " + CarbonPlayerCommon.class.getSimpleName() + " from " + String.valueOf(player.getClass()));
        }
        @Nullable String username = common.username;
        return saveResult.exceptionally((Function)PlayerUtils.saveExceptionHandler(logger, username, player.uuid()));
    }

    public static <T> Function<Throwable, @Nullable T> joinExceptionHandler(Logger logger, String username, UUID uuid) {
        return thr -> {
            logger.warn("Exception handling join for player uuid='{}', username='{}'", (Object)uuid, (Object)PlayerUtils.username(username), thr);
            return null;
        };
    }

    public static Function<Throwable, @Nullable Void> saveExceptionHandler(Logger logger, @Nullable String username, UUID uuid) {
        return thr -> {
            logger.warn("Exception saving data for player uuid='{}', username='{}'", (Object)uuid, (Object)PlayerUtils.username(username), thr);
            return null;
        };
    }

    private static String username(@Nullable String username) {
        return username == null ? "<unresolved>" : username;
    }
}

