/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.spongepowered.configurate.loader.AtomicFiles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.serialisation.gson.UUIDSerializerGson;
import net.draycia.carbon.common.util.FileUtil;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class ProfileCache {
    private static final long REMOVE_AFTER = Duration.ofDays(7L).toMillis();
    private static final long REMOVE_NULL_IDS_AFTER = Duration.ofHours(1L).toMillis();
    private final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDSerializerGson()).create();
    private final Path cacheFile;
    private final Map<UUID, CacheEntry> byId;
    private final Map<String, CacheEntry> byName;
    private final Set<CacheEntry> entries;

    @Inject
    private ProfileCache(@DataDirectory Path dataDirectory) {
        this.cacheFile = dataDirectory.resolve("users/profile_cache.json");
        this.byId = new HashMap<UUID, CacheEntry>();
        this.byName = new HashMap<String, CacheEntry>();
        this.entries = new HashSet<CacheEntry>();
        this.load();
    }

    public synchronized @Nullable String cachedName(UUID id) {
        @Nullable CacheEntry entry = this.byId.get(id);
        if (entry == null) {
            return null;
        }
        if (entry.updated() < ProfileCache.cutoff()) {
            return null;
        }
        return entry.name();
    }

    public synchronized @Nullable UUID cachedId(String name) {
        @Nullable CacheEntry entry = this.byName.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.updated() < ProfileCache.cutoff()) {
            return null;
        }
        return entry.uuid();
    }

    public synchronized boolean hasCachedEntry(String name) {
        @Nullable CacheEntry entry = this.byName.get(name);
        if (entry == null) {
            return false;
        }
        return entry.updated() >= ProfileCache.cutoff();
    }

    public synchronized boolean hasCachedEntry(UUID uuid) {
        @Nullable CacheEntry entry = this.byId.get(uuid);
        if (entry == null) {
            return false;
        }
        return entry.updated() >= ProfileCache.cutoff();
    }

    public synchronized void cache(@Nullable UUID uuid, @Nullable String name) {
        CacheEntry r2;
        @Nullable CacheEntry r1 = uuid == null ? null : this.byId.remove(uuid);
        CacheEntry cacheEntry = r2 = name == null ? null : this.byName.remove(name);
        if (r1 != null) {
            this.entries.remove(r1);
        }
        if (r2 != null) {
            this.entries.remove(r2);
        }
        CacheEntry entry = new CacheEntry(uuid, name, System.currentTimeMillis());
        this.entries.add(entry);
        if (entry.name() != null) {
            this.byName.put(entry.name(), entry);
        }
        if (entry.uuid() != null) {
            this.byId.put(entry.uuid(), entry);
        }
    }

    private synchronized void cleanup() {
        long cutoff = ProfileCache.cutoff();
        long nullIdCutoff = ProfileCache.nullIdCutoff();
        Iterator<CacheEntry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            CacheEntry entry = iterator.next();
            if (entry.updated() >= cutoff && (entry.uuid() != null || entry.updated() >= nullIdCutoff)) continue;
            iterator.remove();
            if (entry.uuid() != null) {
                this.byId.remove(entry.uuid());
            }
            if (entry.name() == null) continue;
            this.byName.remove(entry.name());
        }
    }

    private static long nullIdCutoff() {
        return System.currentTimeMillis() - REMOVE_NULL_IDS_AFTER;
    }

    private static long cutoff() {
        return System.currentTimeMillis() - REMOVE_AFTER;
    }

    private synchronized void load() {
        this.entries.clear();
        this.byId.clear();
        this.byName.clear();
        if (!Files.exists(this.cacheFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.cacheFile);){
            Set load = (Set)this.gson.fromJson((Reader)reader, new TypeToken<Set<CacheEntry>>(this){}.getType());
            this.entries.addAll(load);
            for (CacheEntry entry : this.entries) {
                if (entry.name() != null) {
                    this.byName.put(entry.name(), entry);
                }
                if (entry.uuid() == null) continue;
                this.byId.put(entry.uuid(), entry);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to load cache", ex);
        }
    }

    public synchronized void save() {
        this.cleanup();
        try (BufferedWriter writer = AtomicFiles.atomicBufferedWriter(FileUtil.mkParentDirs(this.cacheFile), StandardCharsets.UTF_8);){
            this.gson.toJson(this.entries, (Appendable)writer);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to save cache", ex);
        }
    }

    private record CacheEntry(@Nullable UUID uuid, @Nullable String name, long updated) {
    }
}

