/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.github.miniplaceholders.api.MiniPlaceholders;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.Party;
import net.draycia.carbon.api.util.InventorySlot;
import net.draycia.carbon.common.config.PrimaryConfig;
import net.draycia.carbon.common.integration.miniplaceholders.MiniPlaceholdersUtil;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.draycia.carbon.common.messages.TagPermissions;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.util.Tristate;
import org.jetbrains.annotations.NotNull;

@DefaultQualifier(value=NonNull.class)
public abstract class WrappedCarbonPlayer
implements CarbonPlayer {
    protected final CarbonPlayerCommon carbonPlayerCommon;

    protected WrappedCarbonPlayer(CarbonPlayerCommon carbonPlayerCommon) {
        this.carbonPlayerCommon = carbonPlayerCommon;
    }

    public CarbonPlayerCommon carbonPlayerCommon() {
        return this.carbonPlayerCommon;
    }

    public @Nullable User user() {
        return LuckPermsProvider.get().getUserManager().getUser(this.uuid());
    }

    public Component parseMessageTags(String message) {
        TagResolver.Builder resolver = TagResolver.builder();
        if (MiniPlaceholdersUtil.miniPlaceholdersLoaded() && this.hasPermission("carbon.chatplaceholders")) {
            resolver.resolver(MiniPlaceholders.globalPlaceholders());
            resolver.resolver(MiniPlaceholders.audiencePlaceholders());
        }
        return TagPermissions.parseTags(this, "carbon.messagetags", message, this::hasPermission, resolver);
    }

    @Override
    public boolean awareOf(CarbonPlayer other) {
        if (other.vanished()) {
            return this.hasPermission("carbon.whisper.vanished");
        }
        return true;
    }

    @Override
    public Set<UUID> ignoring() {
        return this.carbonPlayerCommon.ignoring();
    }

    @Override
    public boolean ignoring(UUID player) {
        return this.carbonPlayerCommon.ignoring(player);
    }

    @Override
    public boolean ignoring(CarbonPlayer player) {
        return this.carbonPlayerCommon.ignoring(player);
    }

    @Override
    public void ignoring(UUID player, boolean nowIgnoring) {
        this.carbonPlayerCommon.ignoring(player, nowIgnoring);
    }

    @Override
    public void ignoring(CarbonPlayer player, boolean nowIgnoring) {
        this.carbonPlayerCommon.ignoring(player, nowIgnoring);
    }

    @Override
    public boolean ignoringDirectMessages() {
        return this.carbonPlayerCommon.ignoringDirectMessages();
    }

    @Override
    public void ignoringDirectMessages(boolean ignoring) {
        this.carbonPlayerCommon.ignoringDirectMessages(ignoring);
    }

    @Override
    public boolean hasPermission(String permission) {
        @Nullable User user = this.user();
        if (user == null) {
            return false;
        }
        CachedPermissionData data = user.getCachedData().getPermissionData(user.getQueryOptions());
        return data.checkPermission(permission) == Tristate.TRUE;
    }

    @Override
    public String primaryGroup() {
        @Nullable User user = this.user();
        if (user == null) {
            return "default";
        }
        return user.getPrimaryGroup();
    }

    @Override
    public List<String> groups() {
        @Nullable User user = this.user();
        if (user == null) {
            return List.of("default");
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (Group group : user.getInheritedGroups(user.getQueryOptions())) {
            groups.add(group.getName());
        }
        return groups;
    }

    @Override
    public String username() {
        return this.carbonPlayerCommon.username();
    }

    @Override
    public Component displayName() {
        @Nullable Component nick = this.nickname();
        if (nick != null) {
            String plainNick;
            PrimaryConfig.NicknameSettings nicknames = this.carbonPlayerCommon.configManager().primaryConfig().nickname();
            if (nicknames.skipFormatWhenNameMatches && (plainNick = PlainTextComponentSerializer.plainText().serialize(nick)).equals(this.username())) {
                return nick;
            }
            try {
                return this.carbonPlayerCommon.messageRenderer().render((Audience)SourcedAudience.of(this, this), nicknames.format, (Map<String, ?>)Map.of("username", Tag.preProcessParsed((String)this.username()), "nickname", Tag.selfClosingInserting((Component)nick)), (Method)null, (Type)null);
            }
            catch (StackOverflowError overflow) {
                throw new RuntimeException("Invalid nickname format '%s'. Makes circular reference to CarbonPlayer#displayName().".formatted(nicknames.format), overflow);
            }
        }
        return this.platformDisplayName().orElseGet(() -> Component.text((String)this.username()));
    }

    protected abstract Optional<Component> platformDisplayName();

    @Override
    public boolean hasNickname() {
        return this.carbonPlayerCommon.hasNickname();
    }

    @Override
    public @Nullable Component nickname() {
        return this.carbonPlayerCommon.nickname();
    }

    @Override
    public void nickname(@Nullable Component nickname) {
        this.carbonPlayerCommon.nickname(nickname);
    }

    @Override
    public UUID uuid() {
        return this.carbonPlayerCommon.uuid();
    }

    @Override
    public @Nullable Component createItemHoverComponent(InventorySlot slot) {
        return this.carbonPlayerCommon.createItemHoverComponent(slot);
    }

    @Override
    public @Nullable Locale locale() {
        return this.carbonPlayerCommon.locale();
    }

    @Override
    public CarbonPlayer.ChannelMessage channelForMessage(Component message) {
        String text = PlainTextComponentSerializer.plainText().serialize(message);
        Component formattedMessage = message;
        ChatChannel channel = Objects.requireNonNullElse(this.selectedChannel(), this.carbonPlayerCommon.channelRegistry().defaultChannel());
        for (Key channelKey : this.carbonPlayerCommon.channelRegistry().keys()) {
            ChatChannel chatChannel = this.carbonPlayerCommon.channelRegistry().channelOrThrow(channelKey);
            @Nullable String prefix = chatChannel.quickPrefix();
            if (prefix == null || !text.startsWith(prefix) || !chatChannel.permissions().speechPermitted(this).permitted()) continue;
            channel = chatChannel;
            formattedMessage = formattedMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().once().matchLiteral(channel.quickPrefix()).replacement((ComponentLike)Component.empty()).build());
            break;
        }
        return new CarbonPlayer.ChannelMessage(formattedMessage, channel);
    }

    @Override
    public @Nullable ChatChannel selectedChannel() {
        return this.carbonPlayerCommon.selectedChannel();
    }

    @Override
    public void selectedChannel(@Nullable ChatChannel chatChannel) {
        this.carbonPlayerCommon.selectedChannel(chatChannel);
    }

    @Override
    public boolean muted() {
        return this.carbonPlayerCommon.muted();
    }

    @Override
    public void muted(boolean muted) {
        this.carbonPlayerCommon.muted(muted);
    }

    @Override
    public long muteExpiration() {
        return this.carbonPlayerCommon.muteExpiration();
    }

    @Override
    public void muteExpiration(long epochMillis) {
        this.carbonPlayerCommon.muteExpiration(epochMillis);
    }

    @Override
    public boolean deafened() {
        return this.carbonPlayerCommon.deafened();
    }

    @Override
    public void deafened(boolean deafened) {
        this.carbonPlayerCommon.deafened(deafened);
    }

    @Override
    public boolean spying() {
        return this.carbonPlayerCommon.spying();
    }

    @Override
    public void spying(boolean spying) {
        this.carbonPlayerCommon.spying(spying);
    }

    @Override
    public void sendMessageAsPlayer(String message) {
        this.carbonPlayerCommon.sendMessageAsPlayer(message);
    }

    @Override
    public boolean online() {
        return this.carbonPlayerCommon.online();
    }

    @Override
    public @Nullable UUID whisperReplyTarget() {
        return this.carbonPlayerCommon.whisperReplyTarget();
    }

    @Override
    public void whisperReplyTarget(@Nullable UUID uuid) {
        this.carbonPlayerCommon.whisperReplyTarget(uuid);
    }

    @Override
    public @Nullable UUID lastWhisperTarget() {
        return this.carbonPlayerCommon.lastWhisperTarget();
    }

    @Override
    public void lastWhisperTarget(@Nullable UUID uuid) {
        this.carbonPlayerCommon.lastWhisperTarget(uuid);
    }

    @NotNull
    public Identity identity() {
        return this.carbonPlayerCommon.identity();
    }

    @Override
    public boolean vanished() {
        return this.carbonPlayerCommon.vanished();
    }

    @Override
    public List<Key> leftChannels() {
        return this.carbonPlayerCommon.leftChannels();
    }

    @Override
    public void joinChannel(ChatChannel channel) {
        this.carbonPlayerCommon.joinChannel(channel);
    }

    @Override
    public void leaveChannel(ChatChannel channel) {
        this.carbonPlayerCommon.leaveChannel(channel);
    }

    public boolean equals(@Nullable Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WrappedCarbonPlayer that = (WrappedCarbonPlayer)other;
        return this.carbonPlayerCommon.equals(that.carbonPlayerCommon);
    }

    public int hashCode() {
        return this.carbonPlayerCommon.hashCode();
    }

    public @Nullable UUID partyId() {
        return this.carbonPlayerCommon.partyId();
    }

    @Override
    public CompletableFuture<@Nullable Party> party() {
        return this.carbonPlayerCommon.party();
    }

    public void party(@Nullable Party party) {
        this.carbonPlayerCommon.party(party);
    }

    @Override
    public boolean applyOptionalChatFilters() {
        return this.carbonPlayerCommon.applyOptionalChatFilters();
    }

    @Override
    public void applyOptionalChatFilters(boolean applyOptionalChatFilters) {
        this.carbonPlayerCommon.applyOptionalChatFilters(applyOptionalChatFilters);
    }
}

