/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users.db;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.zaxxer.hikari.HikariConfig;
import carbonchat.libs.com.zaxxer.hikari.HikariDataSource;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.flywaydb.core.Flyway;
import carbonchat.libs.org.flywaydb.core.api.logging.Log;
import carbonchat.libs.org.flywaydb.core.api.logging.LogCreator;
import carbonchat.libs.org.flywaydb.core.api.logging.LogFactory;
import carbonchat.libs.org.jdbi.v3.core.Handle;
import carbonchat.libs.org.jdbi.v3.core.Jdbi;
import carbonchat.libs.org.jdbi.v3.core.argument.ArgumentFactory;
import carbonchat.libs.org.jdbi.v3.core.mapper.ColumnMapper;
import carbonchat.libs.org.jdbi.v3.core.mapper.RowMapper;
import carbonchat.libs.org.jdbi.v3.core.spi.JdbiPlugin;
import carbonchat.libs.org.jdbi.v3.core.statement.PreparedBatch;
import carbonchat.libs.org.jdbi.v3.core.statement.Query;
import carbonchat.libs.org.jdbi.v3.core.statement.Update;
import carbonchat.libs.org.jdbi.v3.sqlobject.SqlObjectPlugin;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.sql.DataSource;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.config.DatabaseSettings;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.users.CachingUserManager;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.PartyImpl;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.users.db.QueriesLocator;
import net.draycia.carbon.common.users.db.argument.ComponentArgumentFactory;
import net.draycia.carbon.common.users.db.argument.KeyArgumentFactory;
import net.draycia.carbon.common.users.db.mapper.ComponentColumnMapper;
import net.draycia.carbon.common.users.db.mapper.KeyColumnMapper;
import net.draycia.carbon.common.users.db.mapper.PartyRowMapper;
import net.draycia.carbon.common.users.db.mapper.PlayerRowMapper;
import net.draycia.carbon.common.util.ConcurrentUtil;
import net.draycia.carbon.common.util.SQLDrivers;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class DatabaseUserManager
extends CachingUserManager {
    private final Jdbi jdbi;
    private final QueriesLocator locator;
    private final ChannelRegistry channelRegistry;
    private final HikariDataSource dataSource;

    private DatabaseUserManager(Jdbi jdbi, HikariDataSource dataSource, QueriesLocator locator, Logger logger, ProfileResolver profileResolver, Injector injector, Provider<MessagingManager> messagingManager, PacketFactory packetFactory, ChannelRegistry channelRegistry, CarbonServer server) {
        super(logger, profileResolver, injector, messagingManager, packetFactory, server);
        this.jdbi = jdbi;
        this.dataSource = dataSource;
        this.locator = locator;
        this.channelRegistry = channelRegistry;
    }

    @Override
    public CarbonPlayerCommon loadOrCreate(UUID uuid) {
        return (CarbonPlayerCommon)this.jdbi.withHandle(handle -> {
            @Nullable CarbonPlayerCommon carbonPlayerCommon = ((Query)handle.createQuery(this.locator.query("select-player")).bind("id", uuid)).mapTo(CarbonPlayerCommon.class).findOne().orElse(null);
            if (carbonPlayerCommon == null) {
                return new CarbonPlayerCommon(null, uuid);
            }
            ((Query)handle.createQuery(this.locator.query("select-ignores")).bind("id", uuid)).mapTo(UUID.class).forEach(ignoredPlayer -> carbonPlayerCommon.ignoring((UUID)ignoredPlayer, true, true));
            ((Query)handle.createQuery(this.locator.query("select-leftchannels")).bind("id", uuid)).mapTo(Key.class).forEach(channel -> {
                @Nullable ChatChannel chatChannel = this.channelRegistry.channel((Key)channel);
                if (chatChannel == null) {
                    return;
                }
                carbonPlayerCommon.leaveChannel(chatChannel, true);
            });
            return carbonPlayerCommon;
        });
    }

    @Override
    public void saveSync(CarbonPlayerCommon player) {
        this.jdbi.useTransaction(handle -> {
            List<Key> left;
            int inserted = this.bindPlayerArguments(handle.createUpdate(this.locator.query("insert-player")), player).execute();
            if (inserted != 1) {
                this.bindPlayerArguments(handle.createUpdate(this.locator.query("update-player")), player).execute();
            }
            ((Update)handle.createUpdate(this.locator.query("clear-ignores")).bind("id", player.uuid())).execute();
            ((Update)handle.createUpdate(this.locator.query("clear-leftchannels")).bind("id", player.uuid())).execute();
            Set<UUID> ignored = player.ignoring();
            if (!ignored.isEmpty()) {
                PreparedBatch batch = handle.prepareBatch(this.locator.query("save-ignores"));
                for (UUID ignoredPlayer : ignored) {
                    ((PreparedBatch)((PreparedBatch)batch.bind("id", player.uuid())).bind("ignoredplayer", ignoredPlayer)).add();
                }
                batch.execute();
            }
            if (!(left = player.leftChannels()).isEmpty()) {
                PreparedBatch batch = handle.prepareBatch(this.locator.query("save-leftchannels"));
                for (Key leftChannel : left) {
                    ((PreparedBatch)((PreparedBatch)batch.bind("id", player.uuid())).bind("channel", (Object)leftChannel)).add();
                }
                batch.execute();
            }
        });
    }

    @Override
    protected @Nullable PartyImpl loadParty(UUID uuid) {
        return (PartyImpl)this.jdbi.withHandle(handle -> {
            @Nullable PartyImpl party = this.selectParty(handle, uuid);
            if (party == null) {
                return null;
            }
            List members = ((Query)handle.createQuery(this.locator.query("select-party-members")).bind("partyid", uuid)).mapTo(UUID.class).list();
            party.rawMembers().addAll(members);
            return party;
        });
    }

    private @Nullable PartyImpl selectParty(Handle handle, UUID uuid) {
        return ((Query)handle.createQuery(this.locator.query("select-party")).bind("partyid", uuid)).mapTo(PartyImpl.class).findOne().orElse(null);
    }

    @Override
    protected void saveSync(PartyImpl party, Map<UUID, PartyImpl.ChangeType> changes) {
        this.jdbi.useTransaction(handle -> {
            @Nullable PartyImpl existing = this.selectParty(handle, party.id());
            if (existing == null) {
                ((Update)((Update)handle.createUpdate(this.locator.query("insert-party")).bind("partyid", party.id())).bind("name", party.serializedName())).execute();
            }
            PreparedBatch add = null;
            PreparedBatch remove = null;
            for (Map.Entry entry : changes.entrySet()) {
                UUID id = (UUID)entry.getKey();
                PartyImpl.ChangeType type = (PartyImpl.ChangeType)((Object)((Object)entry.getValue()));
                switch (type) {
                    case ADD: {
                        if (add == null) {
                            add = handle.prepareBatch(this.locator.query("insert-party-member"));
                        }
                        ((PreparedBatch)((PreparedBatch)add.bind("partyid", party.id())).bind("playerid", id)).add();
                        break;
                    }
                    case REMOVE: {
                        if (remove == null) {
                            remove = handle.prepareBatch(this.locator.query("drop-party-member"));
                        }
                        ((PreparedBatch)remove.bind("playerid", id)).add();
                    }
                }
            }
            if (add != null) {
                add.execute();
            }
            if (remove != null) {
                remove.execute();
            }
        });
    }

    @Override
    public void disbandSync(UUID id) {
        this.jdbi.useHandle(handle -> {
            ((Update)handle.createUpdate(this.locator.query("drop-party")).bind("partyid", id)).execute();
            ((Update)handle.createUpdate(this.locator.query("clear-party-members")).bind("partyid", id)).execute();
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.dataSource.close();
    }

    private Update bindPlayerArguments(Update update, CarbonPlayerCommon player) {
        @Nullable Component nickname = player.nicknameRaw();
        @Nullable String nicknameJson = (String)GsonComponentSerializer.gson().serializeOrNull(nickname);
        if (nicknameJson != null && nicknameJson.toCharArray().length > 8192) {
            this.logger.error("Serialized nickname for player {} was too long ({}>8192), it cannot be saved: {}", (Object)player.uuid(), (Object)nicknameJson.length(), (Object)nicknameJson);
            nicknameJson = null;
        }
        return (Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)update.bind("id", player.uuid())).bind("muted", player.muted())).bind("muteexpiration", player.muteExpiration())).bind("deafened", player.deafened())).bind("selectedchannel", (Object)player.selectedChannelKey())).bind("displayname", nicknameJson)).bind("lastwhispertarget", player.lastWhisperTarget())).bind("whisperreplytarget", player.whisperReplyTarget())).bind("spying", player.spying())).bind("ignoringdms", player.ignoringDirectMessages())).bind("party", player.partyId())).bind("applycustomfilters", player.applyOptionalChatFilters());
    }

    private record CarbonLogCreator(Logger logger) implements LogCreator
    {
        public Log createLogger(final Class<?> clazz) {
            final Logger l = this.logger;
            return new Log(){

                public boolean isDebugEnabled() {
                    return true;
                }

                public void debug(String message) {
                    l.debug("  [{}] {}", (Object)clazz.getSimpleName(), (Object)message);
                }

                public void info(String message) {
                    l.info("  [{}] {}", (Object)clazz.getSimpleName(), (Object)message);
                }

                public void warn(String message) {
                    l.warn("  [{}] {}", (Object)clazz.getSimpleName(), (Object)message);
                }

                public void error(String message) {
                    l.error("  [{}] {}", (Object)clazz.getSimpleName(), (Object)message);
                }

                public void error(String message, Exception e) {
                    l.error("  [{}] {}", (Object)clazz.getSimpleName(), (Object)message, (Object)e);
                }

                public void notice(String message) {
                    l.info("  [{}] (Notice) {}", (Object)clazz.getSimpleName(), (Object)message);
                }
            };
        }
    }

    public static final class Factory {
        private final ChannelRegistry channelRegistry;
        private final ConfigManager configManager;
        private final Logger logger;
        private final ProfileResolver profileResolver;
        private final Injector injector;
        private final Provider<MessagingManager> messagingManager;
        private final PacketFactory packetFactory;
        private final CarbonServer server;

        @Inject
        private Factory(ChannelRegistry channelRegistry, ConfigManager configManager, Logger logger, ProfileResolver profileResolver, Injector injector, Provider<MessagingManager> messagingManager, PacketFactory packetFactory, CarbonServer server) {
            this.channelRegistry = channelRegistry;
            this.configManager = configManager;
            this.logger = logger;
            this.profileResolver = profileResolver;
            this.injector = injector;
            this.messagingManager = messagingManager;
            this.packetFactory = packetFactory;
            this.server = server;
        }

        public DatabaseUserManager create(String migrationsLocation, Consumer<Jdbi> configureJdbi) {
            return this.create(migrationsLocation, configureJdbi, this.configManager.primaryConfig().databaseSettings());
        }

        public DatabaseUserManager create(String migrationsLocation, Consumer<Jdbi> configureJdbi, DatabaseSettings databaseSettings) {
            SQLDrivers.loadFrom(this.getClass().getClassLoader());
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl(databaseSettings.url());
            hikariConfig.setUsername(databaseSettings.username());
            hikariConfig.setPassword(databaseSettings.password());
            hikariConfig.setPoolName("CarbonChat-HikariPool");
            hikariConfig.setThreadFactory(ConcurrentUtil.carbonThreadFactory(this.logger, "HikariPool"));
            DatabaseSettings.ConnectionPool cfg = Objects.requireNonNull(this.configManager.primaryConfig().databaseSettings().connectionPool());
            hikariConfig.setMaximumPoolSize(cfg.maximumPoolSize);
            hikariConfig.setMinimumIdle(cfg.minimumIdle);
            hikariConfig.setMaxLifetime(cfg.maximumLifetime);
            hikariConfig.setKeepaliveTime(cfg.keepaliveTime);
            hikariConfig.setConnectionTimeout(cfg.connectionTimeout);
            HikariDataSource dataSource = new HikariDataSource(hikariConfig);
            Flyway flyway = Flyway.configure((ClassLoader)CarbonChat.class.getClassLoader()).baselineVersion("0").baselineOnMigrate(true).locations(new String[]{migrationsLocation}).dataSource((DataSource)dataSource).validateMigrationNaming(true).validateOnMigrate(true).load();
            LogFactory.setLogCreator((LogCreator)new CarbonLogCreator(this.logger));
            this.logger.info("Executing Flyway database migrations...");
            flyway.repair();
            flyway.migrate();
            LogFactory.setLogCreator(null);
            Jdbi jdbi = ((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)((Jdbi)Jdbi.create((DataSource)dataSource).registerArgument((ArgumentFactory)new ComponentArgumentFactory())).registerArgument((ArgumentFactory)new KeyArgumentFactory())).registerRowMapper(CarbonPlayerCommon.class, (RowMapper)new PlayerRowMapper())).registerRowMapper(PartyImpl.class, (RowMapper)new PartyRowMapper())).registerColumnMapper(Key.class, (ColumnMapper)new KeyColumnMapper())).registerColumnMapper(Component.class, (ColumnMapper)new ComponentColumnMapper())).installPlugin((JdbiPlugin)new SqlObjectPlugin());
            configureJdbi.accept(jdbi);
            return new DatabaseUserManager(jdbi, dataSource, new QueriesLocator(this.configManager.primaryConfig().storageType()), this.logger, this.profileResolver, this.injector, this.messagingManager, this.packetFactory, this.channelRegistry, this.server);
        }
    }
}

