/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users.db;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import carbonchat.libs.org.jdbi.v3.core.locator.ClasspathSqlLocator;
import carbonchat.libs.org.jdbi.v3.core.locator.internal.ClasspathBuilder;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.common.config.PrimaryConfig;

@DefaultQualifier(value=NonNull.class)
public final class QueriesLocator {
    private static final String PREFIX = "queries/";
    private static final Splitter SPLITTER = Splitter.on((char)';');
    private final ClasspathSqlLocator locator = ClasspathSqlLocator.create();
    private final PrimaryConfig.StorageType storageType;
    private final Pattern templatePattern = Pattern.compile("\\{([^}]*?)}");
    private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

    public QueriesLocator(PrimaryConfig.StorageType storageType) {
        this.storageType = storageType;
    }

    public List<String> queries(String name) {
        return SPLITTER.splitToList((CharSequence)this.query(name));
    }

    public String query(String name) {
        return this.locate(PREFIX + name);
    }

    private String locate(String name) {
        return this.cache.computeIfAbsent(name, $ -> {
            String sql = this.locator.getResource(CarbonChat.class.getClassLoader(), new ClasspathBuilder().appendDotPath(name).setExtension("sql").build());
            return this.processTemplates(sql);
        });
    }

    private String processTemplates(String sql) {
        return this.templatePattern.matcher(sql).replaceAll(match -> {
            String insideBraces = match.group(1);
            try {
                int colonIndex = insideBraces.indexOf(58);
                String prefix = insideBraces.substring(0, colonIndex);
                String content = insideBraces.substring(colonIndex + 1);
                boolean not = false;
                if (prefix.startsWith("!")) {
                    not = true;
                    prefix = prefix.substring(1);
                }
                PrimaryConfig.StorageType storageType = PrimaryConfig.StorageType.valueOf(prefix);
                if (not) {
                    return storageType != this.storageType ? content : "";
                }
                return storageType == this.storageType ? content : "";
            }
            catch (Exception ex) {
                return match.group(0);
            }
        });
    }
}

