/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users.db.argument;

import carbonchat.libs.org.jdbi.v3.core.argument.AbstractArgumentFactory;
import carbonchat.libs.org.jdbi.v3.core.argument.Argument;
import carbonchat.libs.org.jdbi.v3.core.config.ConfigRegistry;
import java.util.UUID;

public final class BinaryUUIDArgumentFactory
extends AbstractArgumentFactory<UUID> {
    public BinaryUUIDArgumentFactory() {
        super(-2);
    }

    public Argument build(UUID value, ConfigRegistry config) {
        return (position, statement, ctx) -> statement.setBytes(position, BinaryUUIDArgumentFactory.unhex(value.toString().replace("-", "")));
    }

    private static byte[] unhex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

