/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.users.json;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.channels.ChannelRegistry;
import net.draycia.carbon.api.channels.ChatChannel;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.channels.CarbonChannelRegistry;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.serialisation.gson.ChatChannelSerializerGson;
import net.draycia.carbon.common.serialisation.gson.UUIDSerializerGson;
import net.draycia.carbon.common.users.CachingUserManager;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.PartyImpl;
import net.draycia.carbon.common.users.PersistentUserProperty;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.util.Exceptions;
import net.draycia.carbon.common.util.FileUtil;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public class JSONUserManager
extends CachingUserManager {
    private final Gson serializer;
    private final Path userDirectory;
    private final Path partyDirectory;
    private final ChannelRegistry channelRegistry;

    @Inject
    public JSONUserManager(@DataDirectory Path dataDirectory, Logger logger, ProfileResolver profileResolver, Injector injector, ChatChannelSerializerGson channelSerializer, UUIDSerializerGson uuidSerializer, Provider<MessagingManager> messagingManager, PacketFactory packetFactory, CarbonChannelRegistry channelRegistry, CarbonServer server) throws IOException {
        super(logger, profileResolver, injector, messagingManager, packetFactory, server);
        this.userDirectory = dataDirectory.resolve("users");
        this.partyDirectory = dataDirectory.resolve("party");
        this.channelRegistry = channelRegistry;
        Files.createDirectories(this.userDirectory, new FileAttribute[0]);
        Files.createDirectories(this.partyDirectory, new FileAttribute[0]);
        this.serializer = ((GsonBuilder)GsonComponentSerializer.gson().populator().apply(new GsonBuilder())).registerTypeAdapter(ChatChannel.class, (Object)channelSerializer).registerTypeAdapter(UUID.class, (Object)uuidSerializer).registerTypeAdapter(PersistentUserProperty.class, (Object)new PersistentUserProperty.Serializer()).setPrettyPrinting().create();
    }

    @Override
    protected CarbonPlayerCommon loadOrCreate(UUID uuid) {
        Path userFile = this.userFile(uuid);
        if (Files.exists(userFile, new LinkOption[0])) {
            try {
                CarbonPlayerCommon player;
                try (BufferedReader reader = Files.newBufferedReader(userFile);){
                    player = (CarbonPlayerCommon)this.serializer.fromJson((Reader)reader, CarbonPlayerCommon.class);
                }
                if (player == null) {
                    throw new IllegalStateException("Player file found but was empty.");
                }
                player.leftChannels().forEach(channel -> {
                    if (this.channelRegistry.channel((Key)channel) == null) {
                        player.joinChannel((Key)channel, true);
                    }
                });
                return player;
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return new CarbonPlayerCommon(null, uuid);
    }

    private Path userFile(UUID id) {
        return this.userDirectory.resolve(String.valueOf(id) + ".json");
    }

    private Path partyFile(UUID id) {
        return this.partyDirectory.resolve(String.valueOf(id) + ".json");
    }

    @Override
    public void saveSync(CarbonPlayerCommon player) {
        Path userFile = this.userFile(player.uuid());
        try {
            String json = this.serializer.toJson((Object)player);
            if (json == null || json.isBlank()) {
                throw new IllegalStateException("No data to save - toJson returned null or blank.");
            }
            Files.writeString(FileUtil.mkParentDirs(userFile), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Exception while saving data for player [%s]".formatted(player.username()), exception);
        }
    }

    @Override
    protected @Nullable PartyImpl loadParty(UUID uuid) {
        Path partyFile = this.partyFile(uuid);
        if (Files.exists(partyFile, new LinkOption[0])) {
            try {
                PartyImpl party;
                try (BufferedReader reader = Files.newBufferedReader(partyFile);){
                    party = (PartyImpl)this.serializer.fromJson((Reader)reader, PartyImpl.class);
                }
                if (party == null) {
                    throw new IllegalStateException("Party file found but was empty.");
                }
                return party;
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    @Override
    protected void saveSync(PartyImpl party, Map<UUID, PartyImpl.ChangeType> changes) {
        Path partyFile = this.partyFile(party.id());
        try {
            String json = this.serializer.toJson((Object)party);
            if (json == null || json.isBlank()) {
                throw new IllegalStateException("No data to save - toJson returned null or blank.");
            }
            Files.writeString(FileUtil.mkParentDirs(partyFile), (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException exception) {
            throw new RuntimeException("Exception while saving data for party " + String.valueOf(party), exception);
        }
    }

    @Override
    public void disbandSync(UUID id) {
        try {
            Files.deleteIfExists(this.partyFile(id));
        }
        catch (IOException ex) {
            Exceptions.rethrow(ex);
        }
    }
}

