/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.command.CarbonCommand;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.PlayerCommander;
import net.draycia.carbon.common.command.exception.CommandCompleted;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.apache.logging.log4j.Logger;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.exception.ArgumentParseException;
import org.incendo.cloud.exception.CommandExecutionException;
import org.incendo.cloud.exception.InvalidCommandSenderException;
import org.incendo.cloud.exception.InvalidSyntaxException;
import org.incendo.cloud.exception.NoPermissionException;
import org.incendo.cloud.exception.handling.ExceptionHandler;
import org.incendo.cloud.util.TypeUtils;

@DefaultQualifier(value=NonNull.class)
public final class CloudUtils {
    private static final Component NULL = Component.text((String)"null");
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[^\\s\\w\\-]");
    @Inject
    private static Provider<Set<CarbonCommand>> commands;

    private CloudUtils() {
    }

    public static Map<Key, CommandSettings> defaultCommandSettings() {
        HashMap<Key, CommandSettings> settings = new HashMap<Key, CommandSettings>();
        for (CarbonCommand command : (Set)commands.get()) {
            settings.put(command.key(), command.defaultCommandSettings());
        }
        return settings;
    }

    public static void registerCommands(Set<CarbonCommand> commands, Map<Key, CommandSettings> settings) {
        for (CarbonCommand command : commands) {
            command.commandSettings(settings.get(command.key()));
            if (!command.commandSettings().enabled()) continue;
            command.init();
        }
    }

    public static Component message(Throwable throwable) {
        @Nullable Component msg = ComponentMessageThrowable.getOrConvertMessage((Throwable)throwable);
        return msg == null ? NULL : msg;
    }

    public static void decorateCommandManager(CommandManager<Commander> commandManager, CarbonMessages carbonMessages, Logger logger) {
        CloudUtils.registerExceptionHandlers(commandManager, carbonMessages, logger);
    }

    public static void registerExceptionHandlers(CommandManager<Commander> commandManager, CarbonMessages carbonMessages, Logger logger) {
        commandManager.exceptionController().registerHandler(ArgumentParseException.class, ctx -> carbonMessages.errorCommandArgumentParsing((Audience)ctx.context().sender(), CloudUtils.message(((ArgumentParseException)ctx.exception()).getCause()))).registerHandler(InvalidCommandSenderException.class, ctx -> {
            Set types = ((InvalidCommandSenderException)ctx.exception()).requiredSenderTypes();
            if (types.size() != 1) {
                throw new IllegalStateException();
            }
            carbonMessages.errorCommandInvalidSender((Audience)ctx.context().sender(), TypeUtils.simpleName((Type)((Type)types.iterator().next())));
        }).registerHandler(InvalidSyntaxException.class, ctx -> carbonMessages.errorCommandInvalidSyntax((Audience)ctx.context().sender(), Component.text((String)((InvalidSyntaxException)ctx.exception()).correctSyntax()).replaceText(config -> config.match(SPECIAL_CHARACTERS_PATTERN).replacement(match -> match.color((TextColor)NamedTextColor.WHITE))))).registerHandler(NoPermissionException.class, ctx -> carbonMessages.errorCommandNoPermission((Audience)ctx.context().sender())).registerHandler(CommandExecutionException.class, ctx -> {
            Throwable cause = ((CommandExecutionException)ctx.exception()).getCause();
            logger.warn("Unexpected exception executing command", cause);
            StringWriter writer = new StringWriter();
            cause.printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString().replaceAll("\t", "    ");
            @Nullable Component throwableMessage = CloudUtils.message(cause);
            carbonMessages.errorCommandCommandExecution((Audience)ctx.context().sender(), throwableMessage, stackTrace);
        }).registerHandler(CommandExecutionException.class, ExceptionHandler.unwrappingHandler(CommandCompleted.class)).registerHandler(CommandCompleted.class, ctx -> {
            @Nullable Component msg = ((CommandCompleted)ctx.exception()).componentMessage();
            if (msg != null) {
                ((Commander)ctx.context().sender()).sendMessage(msg);
            }
        });
    }

    public static CarbonPlayer nonPlayerMustProvidePlayer(CarbonMessages messages, Commander commander) {
        if (commander instanceof PlayerCommander) {
            PlayerCommander playerCommander = (PlayerCommander)commander;
            return playerCommander.carbonPlayer();
        }
        throw CommandCompleted.withMessage((ComponentLike)messages.commandNeedsPlayer());
    }
}

