/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyFormat;

@DefaultQualifier(value=NonNull.class)
public final class ColorUtils {
    private static final Pattern spigotLegacyRGB = Pattern.compile("[\u00a7&]x[\u00a7&]([0-9a-fA-F])[\u00a7&]([0-9a-fA-F])[\u00a7&]([0-9a-fA-F])[\u00a7&]([0-9a-fA-F])[\u00a7&]([0-9a-fA-F])[\u00a7&]([0-9a-fA-F])");
    private static final Pattern pluginRGB = Pattern.compile("[\u00a7&]#([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])([0-9a-fA-F])");
    private static final String hexReplacement = "<#$1$2$3$4$5$6>";

    private ColorUtils() {
    }

    public static @Nullable TextColor parseColor(String input) {
        if (input.isEmpty()) {
            return NamedTextColor.WHITE;
        }
        for (NamedTextColor namedColor : NamedTextColor.NAMES.values()) {
            if (!namedColor.toString().equalsIgnoreCase(input)) continue;
            return namedColor;
        }
        if (input.contains("&") || input.contains("\u00a7")) {
            input = input.replace("&", "\u00a7");
            return LegacyComponentSerializer.legacySection().deserialize(input).color();
        }
        return TextColor.fromCSSHexString((String)input);
    }

    public static String legacyToMiniMessage(String input) {
        LegacyFormat format;
        String output = input;
        output = spigotLegacyRGB.matcher(output).replaceAll(hexReplacement);
        output = pluginRGB.matcher(output).replaceAll(hexReplacement);
        for (char c : "0123456789abcdefABCDEF".toCharArray()) {
            TextColor color;
            format = LegacyComponentSerializer.parseChar((char)Character.toLowerCase(c));
            if (format == null || (color = format.color()) == null) continue;
            output = output.replaceAll("[\u00a7&]" + c, "<" + color.asHexString() + ">");
        }
        for (char c : "klmnoKLMNO".toCharArray()) {
            TextDecoration decoration;
            format = LegacyComponentSerializer.parseChar((char)Character.toLowerCase(c));
            if (format == null || (decoration = format.decoration()) == null) continue;
            output = output.replaceAll("[\u00a7&]" + c, "<" + decoration.name() + ">");
        }
        return output;
    }
}

