/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.draycia.carbon.common.util.ExceptionLoggingScheduledThreadPoolExecutor;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class ConcurrentUtil {
    private ConcurrentUtil() {
    }

    public static void shutdownExecutor(ExecutorService service, TimeUnit timeoutUnit, long timeoutLength) {
        boolean didShutdown;
        service.shutdown();
        try {
            didShutdown = service.awaitTermination(timeoutLength, timeoutUnit);
        }
        catch (InterruptedException ignore) {
            didShutdown = false;
        }
        if (!didShutdown) {
            service.shutdownNow();
        }
    }

    public static ThreadFactory carbonThreadFactory(Logger logger, String name) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CarbonChat " + name + " Thread #%d").setUncaughtExceptionHandler((thread, thr) -> logger.warn("Uncaught exception on thread {}", (Object)thread.getName(), (Object)thr)).build();
    }

    public static ScheduledExecutorService createPeriodicTasksPool(Logger logger) {
        return new ExceptionLoggingScheduledThreadPoolExecutor(1, ConcurrentUtil.carbonThreadFactory(logger, "Periodic Tasks"), logger);
    }
}

