/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.draycia.carbon.common.util.Exceptions;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public final class ExceptionLoggingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private final Logger logger;

    public ExceptionLoggingScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, Logger logger) {
        super(corePoolSize, threadFactory);
        this.logger = logger;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new ExceptionLoggingRunnable(command, this.logger), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new ExceptionLoggingRunnable(command, this.logger), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(new ExceptionLoggingRunnable(command, this.logger), initialDelay, delay, unit);
    }

    private record ExceptionLoggingRunnable(Runnable wrapped, Logger logger) implements Runnable
    {
        @Override
        public void run() {
            try {
                this.wrapped.run();
            }
            catch (Throwable thr) {
                this.logger.error("Error executing task '{}'", (Object)this.wrapped, (Object)thr);
                Exceptions.rethrow(thr);
            }
        }
    }
}

