/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import java.util.Arrays;
import java.util.UUID;

public final class FastUuidSansHyphens {
    private static final int MOJANG_BROKEN_UUID_LENGTH = 32;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long[] HEX_VALUES = new long[128];

    private FastUuidSansHyphens() {
    }

    public static UUID parseUuid(CharSequence uuidSequence) {
        if (uuidSequence.length() != 32) {
            throw new IllegalArgumentException("Illegal UUID string: " + String.valueOf(uuidSequence));
        }
        long mostSignificantBits = FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(0)) << 60;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(1)) << 56;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(2)) << 52;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(3)) << 48;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(4)) << 44;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(5)) << 40;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(6)) << 36;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(7)) << 32;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(8)) << 28;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(9)) << 24;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(10)) << 20;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(11)) << 16;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(12)) << 12;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(13)) << 8;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(14)) << 4;
        mostSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(15));
        long leastSignificantBits = FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(16)) << 60;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(17)) << 56;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(18)) << 52;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(19)) << 48;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(20)) << 44;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(21)) << 40;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(22)) << 36;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(23)) << 32;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(24)) << 28;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(25)) << 24;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(26)) << 20;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(27)) << 16;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(28)) << 12;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(29)) << 8;
        leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(30)) << 4;
        return new UUID(mostSignificantBits, leastSignificantBits |= FastUuidSansHyphens.hexValueForChar(uuidSequence.charAt(31)));
    }

    public static String toString(UUID uuid) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        char[] uuidChars = new char[]{HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000000L) >>> 48)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000000L) >>> 32)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0000L) >>> 16)], HEX_DIGITS[(int)((mostSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((mostSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((mostSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(mostSignificantBits & 0xFL)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000000L) >>> 60)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000000L) >>> 56)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000000L) >>> 52)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000000L) >>> 48)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000000L) >>> 44)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000000L) >>> 40)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000000L) >>> 36)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000000L) >>> 32)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000000L) >>> 28)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000000L) >>> 24)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00000L) >>> 20)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0000L) >>> 16)], HEX_DIGITS[(int)((leastSignificantBits & 0xF000L) >>> 12)], HEX_DIGITS[(int)((leastSignificantBits & 0xF00L) >>> 8)], HEX_DIGITS[(int)((leastSignificantBits & 0xF0L) >>> 4)], HEX_DIGITS[(int)(leastSignificantBits & 0xFL)]};
        return new String(uuidChars);
    }

    private static long hexValueForChar(char c) {
        try {
            if (HEX_VALUES[c] < 0L) {
                throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Illegal hexadecimal digit: " + c);
        }
        return HEX_VALUES[c];
    }

    static {
        Arrays.fill(HEX_VALUES, -1L);
        FastUuidSansHyphens.HEX_VALUES[48] = 0L;
        FastUuidSansHyphens.HEX_VALUES[49] = 1L;
        FastUuidSansHyphens.HEX_VALUES[50] = 2L;
        FastUuidSansHyphens.HEX_VALUES[51] = 3L;
        FastUuidSansHyphens.HEX_VALUES[52] = 4L;
        FastUuidSansHyphens.HEX_VALUES[53] = 5L;
        FastUuidSansHyphens.HEX_VALUES[54] = 6L;
        FastUuidSansHyphens.HEX_VALUES[55] = 7L;
        FastUuidSansHyphens.HEX_VALUES[56] = 8L;
        FastUuidSansHyphens.HEX_VALUES[57] = 9L;
        FastUuidSansHyphens.HEX_VALUES[97] = 10L;
        FastUuidSansHyphens.HEX_VALUES[98] = 11L;
        FastUuidSansHyphens.HEX_VALUES[99] = 12L;
        FastUuidSansHyphens.HEX_VALUES[100] = 13L;
        FastUuidSansHyphens.HEX_VALUES[101] = 14L;
        FastUuidSansHyphens.HEX_VALUES[102] = 15L;
        FastUuidSansHyphens.HEX_VALUES[65] = 10L;
        FastUuidSansHyphens.HEX_VALUES[66] = 11L;
        FastUuidSansHyphens.HEX_VALUES[67] = 12L;
        FastUuidSansHyphens.HEX_VALUES[68] = 13L;
        FastUuidSansHyphens.HEX_VALUES[69] = 14L;
        FastUuidSansHyphens.HEX_VALUES[70] = 15L;
    }
}

