/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.draycia.carbon.common.util.Strings;

public final class FileUtil {
    private FileUtil() {
    }

    public static String hashString(Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new IllegalArgumentException("Path '%s' is not a regular file, cannot generate hash string.".formatted(file));
        }
        byte[] hash = com.google.common.io.Files.asByteSource((File)file.toFile()).hash(Hashing.sha256()).asBytes();
        return Strings.asHexString(hash);
    }

    public static List<Path> listDirectoryEntries(Path path) {
        return FileUtil.listDirectoryEntries(path, "*");
    }

    public static List<Path> listDirectoryEntries(Path path, String glob) {
        ArrayList<Path> arrayList;
        block10: {
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException("Path '%s' exists but is not a directory!".formatted(path));
            }
            DirectoryStream<Path> stream = Files.newDirectoryStream(path, glob);
            try {
                ArrayList<Path> ret = new ArrayList<Path>();
                stream.forEach(ret::add);
                arrayList = ret;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new UncheckedIOException("Failed to list directory entries matching '%s' in path '%s'.".formatted(glob, path), exception);
                }
            }
            stream.close();
        }
        return arrayList;
    }

    public static Path mkParentDirs(Path path) throws IOException {
        block3: {
            Path parent = path.getParent();
            if (parent != null && !Files.isDirectory(parent, new LinkOption[0])) {
                try {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException ex) {
                    if (Files.isDirectory(parent, new LinkOption[0])) break block3;
                    throw ex;
                }
            }
        }
        return path;
    }
}

