/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.function.IntFunction;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.util.Pagination;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;

@DefaultQualifier(value=NonNull.class)
public final class PaginationHelper {
    private final CarbonMessages messages;

    @Inject
    private PaginationHelper(CarbonMessages messages) {
        this.messages = messages;
    }

    public Pagination.BiIntFunction<ComponentLike> footerRenderer(IntFunction<String> commandFunction) {
        return (currentPage, pages) -> {
            if (pages == 1) {
                return Component.empty();
            }
            TextComponent.Builder buttons = Component.text();
            if (currentPage > 1) {
                buttons.append(this.previousPageButton(currentPage, commandFunction));
            }
            if (currentPage > 1 && currentPage < pages) {
                buttons.append((Component)Component.space());
            }
            if (currentPage < pages) {
                buttons.append(this.nextPageButton(currentPage, commandFunction));
            }
            return this.messages.paginationFooter(currentPage, pages, (Component)buttons.build());
        };
    }

    private Component previousPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2190").clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage - 1)))).hoverEvent((HoverEventSource)this.messages.paginationClickForPreviousPage())).build();
    }

    private Component nextPageButton(int currentPage, IntFunction<String> commandFunction) {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("\u2192").clickEvent(ClickEvent.runCommand((String)commandFunction.apply(currentPage + 1)))).hoverEvent((HoverEventSource)this.messages.paginationClickForNextPage())).build();
    }
}

