/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.event.ClickEvent;

@DefaultQualifier(value=NonNull.class)
public final class Strings {
    private static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("(?:(https?)://)?([-\\w_.]+\\.\\w{2,})(/\\S*)?");
    private static final Pattern URL_SCHEME_PATTERN = Pattern.compile("^[a-z][a-z0-9+\\-.]*:");
    public static final Supplier<TextReplacementConfig> URL_REPLACEMENT_CONFIG = Suppliers.memoize(() -> (TextReplacementConfig)TextReplacementConfig.builder().match(DEFAULT_URL_PATTERN).replacement(url -> {
        Object clickUrl = url.content();
        if (!URL_SCHEME_PATTERN.matcher((CharSequence)clickUrl).find()) {
            clickUrl = "http://" + (String)clickUrl;
        }
        return url.clickEvent(ClickEvent.openUrl((String)clickUrl));
    }).build());

    private Strings() {
    }

    public static @Nullable String trim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    public static String asHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append("%02x".formatted(b & 0xFF));
        }
        return sb.toString();
    }
}

