/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.common.util;

import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public record UpdateChecker(Logger logger) {
    private static final String GITHUB_REPO = "Hexaoxide/Carbon";
    private static final String UPDATE_CHECKER_FETCHING_VERSION_INFORMATION = "Fetching version information...";
    private static final String DEV_BUILD_NOTICE = "This is a development version of CarbonChat (<version>)!";
    private static final String UPDATE_CHECKER_BEHIND_RELEASES = "CarbonChat is <behind> version(s) out of date (<version>).";
    private static final String UPDATE_CHECKER_DOWNLOAD_RELEASE = "Download the latest release (<latest>) from <link>";
    private static final String RELEASE_DOWNLOADS_URL = "https://modrinth.com/plugin/carbon/versions";
    private static final Gson GSON = new GsonBuilder().create();

    public void checkVersion() {
        Releases releases;
        this.logger.info(UPDATE_CHECKER_FETCHING_VERSION_INFORMATION);
        @Nullable Manifest manifest = UpdateChecker.manifest(UpdateChecker.class);
        if (manifest == null) {
            this.logger.warn("Failed to locate manifest, cannot check for updates.");
            return;
        }
        String currentVersion = manifest.getMainAttributes().getValue("carbon-version");
        try {
            releases = this.fetchReleases();
        }
        catch (IOException e) {
            this.logger.warn("Failed to list releases, cannot check for updates.", (Throwable)e);
            return;
        }
        String ver = "v" + currentVersion;
        if (releases.releaseList().get(0).equals(ver)) {
            return;
        }
        if (currentVersion.contains("-SNAPSHOT")) {
            this.logger.info(DEV_BUILD_NOTICE.replace("<version>", ver));
        } else {
            int versionsBehind = releases.releaseList().indexOf(ver);
            this.logger.info(UPDATE_CHECKER_BEHIND_RELEASES.replace("<behind>", String.valueOf(versionsBehind == -1 ? "?" : Integer.valueOf(versionsBehind))).replace("<version>", ver));
        }
        this.logger.info(UPDATE_CHECKER_DOWNLOAD_RELEASE.replace("<latest>", releases.releaseList().get(0)).replace("<link>", RELEASE_DOWNLOADS_URL));
    }

    private Releases fetchReleases() throws IOException {
        JsonArray result;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create("https://api.github.com/repos/%s/releases".formatted(GITHUB_REPO)).toURL().openStream(), StandardCharsets.UTF_8));){
            result = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
        }
        LinkedHashMap<String, String> versionMap = new LinkedHashMap<String, String>();
        for (JsonElement element : result) {
            versionMap.put(element.getAsJsonObject().get("tag_name").getAsString(), element.getAsJsonObject().get("html_url").getAsString());
        }
        return new Releases(new ArrayList<String>(versionMap.keySet()), versionMap);
    }

    public static @Nullable Manifest manifest(Class<?> clazz) {
        Manifest manifest;
        block9: {
            String classLocation = "/" + clazz.getName().replace(".", "/") + ".class";
            @Nullable URL resource = clazz.getResource(classLocation);
            if (resource == null) {
                return null;
            }
            String classFilePath = resource.toString().replace("\\", "/");
            String archivePath = classFilePath.substring(0, classFilePath.length() - classLocation.length());
            InputStream stream = URI.create(archivePath + "/META-INF/MANIFEST.MF").toURL().openStream();
            try {
                manifest = new Manifest(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return null;
                }
            }
            stream.close();
        }
        return manifest;
    }

    private record Releases(List<String> releaseList, Map<String, String> releaseUrls) {
    }
}

