/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Injector;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.event.CarbonEventHandler;
import net.draycia.carbon.common.CarbonChatInternal;
import net.draycia.carbon.common.PeriodicTasks;
import net.draycia.carbon.common.channels.CarbonChannelRegistry;
import net.draycia.carbon.common.command.ExecutionCoordinatorHolder;
import net.draycia.carbon.common.integration.miniplaceholders.MiniPlaceholdersExpansion;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.users.PlatformUserManager;
import net.draycia.carbon.common.users.ProfileCache;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.fabric.MinecraftServerHolder;
import net.draycia.carbon.fabric.listeners.FabricChatHandler;
import net.draycia.carbon.fabric.listeners.FabricJoinQuitListener;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class CarbonChatFabric
extends CarbonChatInternal {
    @Inject
    private CarbonChatFabric(Injector injector, Logger logger, @PeriodicTasks ScheduledExecutorService periodicTasks, ProfileCache profileCache, ProfileResolver profileResolver, CarbonMessages carbonMessages, PlatformUserManager userManager, ExecutionCoordinatorHolder commandExecutor, CarbonServer carbonServer, CarbonEventHandler eventHandler, CarbonChannelRegistry channelRegistry, Provider<MessagingManager> messagingManagerProvider, MinecraftServerHolder minecraftServerHolder) {
        super(injector, logger, periodicTasks, profileCache, profileResolver, userManager, commandExecutor, carbonServer, carbonMessages, eventHandler, channelRegistry, messagingManagerProvider);
    }

    public void onInitialize() {
        this.init();
        this.registerChatListener();
        this.registerServerLifecycleListeners();
        this.registerPlayerStatusListeners();
        this.loadAddonEntrypoints();
    }

    private void loadAddonEntrypoints() {
        List containers = FabricLoader.getInstance().getEntrypointContainers("carbonchat", Consumer.class);
        for (EntrypointContainer container : containers) {
            try {
                Consumer entrypoint = (Consumer)container.getEntrypoint();
                entrypoint.accept(this);
            }
            catch (Throwable t) {
                this.logger().error("Failed to invoke 'carbonchat' entrypoint for addon mod '{}'", (Object)container.getProvider().getMetadata().getId(), (Object)t);
            }
        }
    }

    private void registerChatListener() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((Object)((ServerMessageEvents.AllowChatMessage)this.injector().getInstance(FabricChatHandler.class)));
    }

    private void registerServerLifecycleListeners() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> MiniPlaceholdersExpansion.register(this.injector()));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.checkVersion());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.shutdown());
    }

    private void registerPlayerStatusListeners() {
        FabricJoinQuitListener listener = (FabricJoinQuitListener)this.injector().getInstance(FabricJoinQuitListener.class);
        ServerPlayConnectionEvents.DISCONNECT.register((Object)listener);
        ServerPlayConnectionEvents.JOIN.register((Object)listener);
    }

    public boolean luckPermsLoaded() {
        return FabricLoader.getInstance().isModLoaded("luckperms");
    }
}

