/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric;

import carbonchat.libs.com.google.inject.Module;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.Provides;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import com.mojang.brigadier.tree.CommandNode;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.draycia.carbon.api.CarbonChat;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.common.CarbonCommonModule;
import net.draycia.carbon.common.CarbonPlatformModule;
import net.draycia.carbon.common.DataDirectory;
import net.draycia.carbon.common.PlatformScheduler;
import net.draycia.carbon.common.RawChat;
import net.draycia.carbon.common.command.CommandSettings;
import net.draycia.carbon.common.command.Commander;
import net.draycia.carbon.common.command.ExecutionCoordinatorHolder;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.common.users.PlatformUserManager;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.common.util.CloudUtils;
import net.draycia.carbon.fabric.CarbonChatFabric;
import net.draycia.carbon.fabric.CarbonServerFabric;
import net.draycia.carbon.fabric.FabricMessageRenderer;
import net.draycia.carbon.fabric.FabricScheduler;
import net.draycia.carbon.fabric.command.FabricCommander;
import net.draycia.carbon.fabric.command.FabricPlayerCommander;
import net.draycia.carbon.fabric.listeners.FabricChatHandler;
import net.draycia.carbon.fabric.users.CarbonPlayerFabric;
import net.draycia.carbon.fabric.users.FabricProfileResolver;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.kyori.adventure.key.Key;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.fabric.FabricServerCommandManager;

@DefaultQualifier(value=NonNull.class)
public final class CarbonChatFabricModule
extends CarbonPlatformModule {
    private final Logger logger;
    private final ModContainer modContainer;

    CarbonChatFabricModule() {
        ModContainer modContainer;
        this.modContainer = modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("carbonchat").orElseThrow(() -> new IllegalStateException("Could not find ModContainer for carbonchat."));
        this.logger = LogManager.getLogger((String)modContainer.getMetadata().getName());
    }

    @Provides
    @Singleton
    public CommandManager<Commander> commandManager(ExecutionCoordinatorHolder executionCoordinatorHolder, Provider<CarbonChatFabric> carbonChat, CarbonMessages carbonMessages) {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            Map<Key, CommandSettings> settings = ((ConfigManager)((CarbonChatFabric)carbonChat.get()).injector().getInstance(ConfigManager.class)).loadCommandSettings();
            Iterator it = dispatcher.getRoot().getChildren().iterator();
            while (it.hasNext()) {
                CommandNode next = (CommandNode)it.next();
                String name = next.getName();
                if (!settings.values().stream().anyMatch(s -> s.name().equals(name) || Arrays.asList(s.aliases()).contains(name))) continue;
                it.remove();
            }
        });
        FabricServerCommandManager commandManager = new FabricServerCommandManager(executionCoordinatorHolder.executionCoordinator(), SenderMapper.create(commandSourceStack -> {
            if (commandSourceStack.method_9228() instanceof class_3222) {
                return new FabricPlayerCommander((CarbonChat)carbonChat.get(), (class_2168)commandSourceStack);
            }
            return FabricCommander.from(commandSourceStack);
        }, commander -> ((FabricCommander)commander).commandSourceStack()));
        CloudUtils.decorateCommandManager((CommandManager<Commander>)commandManager, carbonMessages, this.logger);
        return commandManager;
    }

    @Override
    protected void configurePlatform() {
        this.install((Module)new CarbonCommonModule());
        this.bind(ModContainer.class).toInstance((Object)this.modContainer);
        this.bind(CarbonChat.class).to(CarbonChatFabric.class);
        this.bind(Logger.class).toInstance((Object)this.logger);
        this.bind(Path.class).annotatedWith(DataDirectory.class).toInstance((Object)FabricLoader.getInstance().getConfigDir().resolve(this.modContainer.getMetadata().getId()));
        this.bind(CarbonServer.class).to(CarbonServerFabric.class);
        this.bind(ProfileResolver.class).to(FabricProfileResolver.class);
        this.bind(PlatformScheduler.class).to(FabricScheduler.class);
        this.install(PlatformUserManager.PlayerFactory.moduleFor(CarbonPlayerFabric.class));
        this.bind(CarbonMessageRenderer.class).to(FabricMessageRenderer.class);
        this.bind(Key.class).annotatedWith(RawChat.class).toProvider(() -> FabricChatHandler.CHAT_TYPE_KEY);
    }
}

