/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.Objects;
import net.draycia.carbon.api.CarbonServer;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.users.UserManager;
import net.draycia.carbon.common.users.ConsoleCarbonPlayer;
import net.draycia.carbon.fabric.MinecraftServerHolder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Singleton
@DefaultQualifier(value=NonNull.class)
public final class CarbonServerFabric
implements CarbonServer,
ForwardingAudience.Single {
    private final MinecraftServerHolder serverHolder;
    private final UserManager<?> userManager;

    @Inject
    private CarbonServerFabric(MinecraftServerHolder serverHolder, UserManager<?> userManager) {
        this.serverHolder = serverHolder;
        this.userManager = userManager;
    }

    @NotNull
    public Audience audience() {
        return MinecraftServerAudiences.of((MinecraftServer)this.serverHolder.requireServer()).all();
    }

    @Override
    public Audience console() {
        return new ConsoleCarbonPlayer((Audience)this.serverHolder.requireServer().method_3739());
    }

    @Override
    public List<? extends CarbonPlayer> players() {
        return this.serverHolder.requireServer().method_3760().method_14571().stream().map(serverPlayer -> this.userManager.user(serverPlayer.method_5667()).getNow(null)).filter(Objects::nonNull).toList();
    }
}

