/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import io.github.miniplaceholders.api.MiniPlaceholders;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.integration.miniplaceholders.MiniPlaceholdersUtil;
import net.draycia.carbon.common.messages.CarbonMessageRenderer;
import net.draycia.carbon.common.messages.RenderForTagResolver;
import net.draycia.carbon.common.messages.SourcedAudience;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

@DefaultQualifier(value=NonNull.class)
@Singleton
public class FabricMessageRenderer
extends CarbonMessageRenderer {
    private final ConfigManager configManager;

    @Inject
    public FabricMessageRenderer(ConfigManager configManager, RenderForTagResolver.Factory renderForTagResolver) {
        super(renderForTagResolver);
        this.configManager = configManager;
    }

    @Override
    public Component render(Audience receiver, String intermediateMessage, TagResolver.Builder tagResolver) {
        Audience audience;
        String placeholderResolvedMessage = this.configManager.primaryConfig().applyCustomPlaceholders(intermediateMessage);
        if (FabricLoader.getInstance().isModLoaded("miniplaceholders")) {
            tagResolver.resolver(MiniPlaceholders.globalPlaceholders());
            if (receiver instanceof SourcedAudience) {
                tagResolver.resolver(MiniPlaceholders.audiencePlaceholders());
                tagResolver.resolver(MiniPlaceholders.relationalPlaceholders());
            }
        }
        if (receiver instanceof SourcedAudience) {
            SourcedAudience sourced = (SourcedAudience)receiver;
            audience = MiniPlaceholdersUtil.wrapAudiences(sourced.recipient(), sourced.sender());
        } else {
            audience = receiver;
        }
        Audience parseAudience = audience;
        return MiniMessage.miniMessage().deserialize(placeholderResolvedMessage, (Pointered)parseAudience, tagResolver.build());
    }
}

