/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.Objects;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.server.MinecraftServer;

@DefaultQualifier(value=NonNull.class)
@Singleton
public final class MinecraftServerHolder {
    private volatile @Nullable MinecraftServer server;

    @Inject
    private MinecraftServerHolder() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.server = null;
        });
    }

    public MinecraftServer requireServer() {
        return Objects.requireNonNull(this.server, "server requested when not active");
    }
}

