/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.event.events.CarbonChatEventImpl;
import net.draycia.carbon.common.listeners.ChatListenerInternal;
import net.draycia.carbon.common.messages.CarbonMessages;
import net.draycia.carbon.fabric.CarbonChatFabric;
import net.draycia.carbon.fabric.users.CarbonPlayerFabric;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2168;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7471;
import net.minecraft.class_7604;
import net.minecraft.class_7649;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class FabricChatHandler
extends ChatListenerInternal
implements ServerMessageEvents.AllowChatMessage {
    public static final class_2960 CHAT_TYPE_KEY = class_2960.method_60655((String)"carbonchat", (String)"chat");
    private final CarbonChatFabric carbonChat;
    private @MonotonicNonNull class_5321<class_2556> chatTypeResourceKey;

    @Inject
    public FabricChatHandler(ConfigManager configManager, CarbonChatFabric carbonChat, CarbonMessages carbonMessages) {
        super(carbonChat.eventHandler(), carbonMessages, configManager);
        this.carbonChat = carbonChat;
    }

    public boolean allowChatMessage(class_7471 chatMessage, class_3222 serverPlayer, class_2556.class_7602 bound) {
        String content;
        if (serverPlayer == null) {
            return false;
        }
        @Nullable CarbonPlayer sender = (CarbonPlayer)this.carbonChat.userManager().user(serverPlayer.method_5667()).join();
        @Nullable CarbonChatEventImpl chatEvent = this.prepareAndEmitChatEvent(sender, content = chatMessage.method_46291().getString(), null);
        if (chatEvent == null || chatEvent.cancelled()) {
            return false;
        }
        for (Audience audience : chatEvent.recipients()) {
            Component finishedMessage = chatEvent.renderFor(audience);
            class_2561 nativeMessage = (class_2561)MinecraftServerAudiences.of((MinecraftServer)serverPlayer.method_51469().method_8503()).nonWrappingSerializer().serialize(finishedMessage);
            class_7471 customChatMessage = new class_7471(chatMessage.comp_1083(), chatMessage.comp_1084(), chatMessage.comp_928(), nativeMessage, class_7649.field_39941);
            class_5455 registryAccess = serverPlayer.method_51469().method_30349();
            if (this.chatTypeResourceKey == null) {
                this.chatTypeResourceKey = (class_5321)registryAccess.method_30530(class_7924.field_41237).method_10223(CHAT_TYPE_KEY).flatMap(class_6880.class_6883::method_40230).orElseThrow();
            }
            class_2556.class_7602 customBound = class_2556.method_44834(this.chatTypeResourceKey, (class_5455)registryAccess, (class_2561)nativeMessage);
            if (audience instanceof class_2168) {
                class_2168 recipientSource = (class_2168)audience;
                recipientSource.method_44749((class_7604)new class_7604.class_7607(customChatMessage), false, customBound);
                continue;
            }
            if (!(audience instanceof CarbonPlayerFabric)) continue;
            CarbonPlayerFabric carbonPlayerFabric = (CarbonPlayerFabric)audience;
            carbonPlayerFabric.player().ifPresent(fabricPlayer -> fabricPlayer.method_43505((class_7604)new class_7604.class_7607(customChatMessage), false, customBound));
        }
        return false;
    }
}

