/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric.listeners;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.function.Function;
import net.draycia.carbon.common.config.ConfigManager;
import net.draycia.carbon.common.messaging.MessagingManager;
import net.draycia.carbon.common.messaging.packets.PacketFactory;
import net.draycia.carbon.common.users.PlayerUtils;
import net.draycia.carbon.common.users.ProfileCache;
import net.draycia.carbon.common.users.UserManagerInternal;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2596;
import net.minecraft.class_3244;
import net.minecraft.class_7597;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;

@DefaultQualifier(value=NonNull.class)
public class FabricJoinQuitListener
implements ServerPlayConnectionEvents.Join,
ServerPlayConnectionEvents.Disconnect {
    private final ProfileCache profileCache;
    private final Logger logger;
    private final ConfigManager configManager;
    private final UserManagerInternal<?> userManager;
    private final Provider<MessagingManager> messaging;
    private final PacketFactory packetFactory;

    @Inject
    public FabricJoinQuitListener(Logger logger, ConfigManager configManager, ProfileCache profileCache, UserManagerInternal<?> userManager, Provider<MessagingManager> messaging, PacketFactory packetFactory) {
        this.logger = logger;
        this.configManager = configManager;
        this.profileCache = profileCache;
        this.userManager = userManager;
        this.messaging = messaging;
        this.packetFactory = packetFactory;
    }

    public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
        this.profileCache.cache(handler.method_32311().method_5667(), handler.method_32311().method_7334().name());
        ((MessagingManager)this.messaging.get()).queuePacket(() -> this.packetFactory.addLocalPlayerPacket(handler.method_32311().method_5667(), handler.method_32311().method_7334().name()));
        @Nullable List<String> suggestions = this.configManager.primaryConfig().customChatSuggestions();
        if (suggestions == null || suggestions.isEmpty()) {
            return;
        }
        sender.sendPacket((class_2596)new class_7597(class_7597.class_7598.field_39803, suggestions));
    }

    public void onPlayDisconnect(class_3244 handler, MinecraftServer server) {
        this.userManager.loggedOut(handler.method_32311().method_7334().id()).exceptionally((Function)PlayerUtils.saveExceptionHandler(this.logger, handler.method_32311().method_7334().name(), handler.method_32311().method_7334().id()));
    }
}

