/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric.users;

import carbonchat.libs.com.google.inject.Provider;
import carbonchat.libs.com.google.inject.assistedinject.Assisted;
import carbonchat.libs.com.google.inject.assistedinject.AssistedInject;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.draycia.carbon.api.users.CarbonPlayer;
import net.draycia.carbon.api.util.InventorySlot;
import net.draycia.carbon.common.users.CarbonPlayerCommon;
import net.draycia.carbon.common.users.WrappedCarbonPlayer;
import net.draycia.carbon.common.util.EmptyAudienceWithPointers;
import net.draycia.carbon.fabric.CarbonChatFabric;
import net.draycia.carbon.fabric.MinecraftServerHolder;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

@DefaultQualifier(value=NonNull.class)
public class CarbonPlayerFabric
extends WrappedCarbonPlayer
implements ForwardingAudience.Single {
    private final MinecraftServerHolder serverHolder;
    private final Provider<CarbonChatFabric> carbonChatFabric;

    @AssistedInject
    public CarbonPlayerFabric(@Assisted CarbonPlayerCommon carbonPlayerCommon, MinecraftServerHolder serverHolder, Provider<CarbonChatFabric> carbonChatFabric) {
        super(carbonPlayerCommon);
        this.serverHolder = serverHolder;
        this.carbonChatFabric = carbonChatFabric;
    }

    public @NonNull Audience audience() {
        return this.player().map(p -> p).orElseGet(() -> EmptyAudienceWithPointers.forCarbonPlayer(this));
    }

    public Optional<class_3222> player() {
        return Optional.ofNullable(this.serverHolder.requireServer().method_3760().method_14602(this.carbonPlayerCommon.uuid()));
    }

    @Override
    public boolean vanished() {
        return false;
    }

    @Override
    public @Nullable Locale locale() {
        return this.player().flatMap(player -> player.get(Identity.LOCALE)).orElseGet(Locale::getDefault);
    }

    @Override
    public boolean online() {
        return this.player().isPresent();
    }

    @Override
    public double distanceSquaredFrom(CarbonPlayer other) {
        if (this.player().isEmpty()) {
            return -1.0;
        }
        @Nullable class_3222 player = this.player().orElse(null);
        @Nullable class_3222 otherPlayer = this.serverHolder.requireServer().method_3760().method_14602(other.uuid());
        if (player == null || otherPlayer == null) {
            return -1.0;
        }
        double deltaX = player.method_73189().method_10216() - otherPlayer.method_73189().method_10216();
        double deltaY = player.method_73189().method_10214() - otherPlayer.method_73189().method_10214();
        double deltaZ = player.method_73189().method_10215() - otherPlayer.method_73189().method_10215();
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    @Override
    public boolean sameWorldAs(CarbonPlayer other) {
        if (this.player().isEmpty()) {
            return false;
        }
        Optional<class_3222> player = this.player();
        @Nullable class_3222 otherPlayer = this.serverHolder.requireServer().method_3760().method_14602(other.uuid());
        if (player.isEmpty() || otherPlayer == null) {
            return false;
        }
        return player.get().method_51469().equals(otherPlayer.method_51469());
    }

    @Override
    public @Nullable Component createItemHoverComponent(InventorySlot slot) {
        class_1304 equipmentSlot;
        Optional<class_3222> playerOptional = this.player();
        if (playerOptional.isEmpty()) {
            return null;
        }
        class_3222 player = playerOptional.get();
        if (slot.equals(InventorySlot.MAIN_HAND)) {
            equipmentSlot = class_1304.field_6173;
        } else if (slot.equals(InventorySlot.OFF_HAND)) {
            equipmentSlot = class_1304.field_6171;
        } else if (slot.equals(InventorySlot.HELMET)) {
            equipmentSlot = class_1304.field_6169;
        } else if (slot.equals(InventorySlot.CHEST)) {
            equipmentSlot = class_1304.field_6174;
        } else if (slot.equals(InventorySlot.LEGS)) {
            equipmentSlot = class_1304.field_6172;
        } else if (slot.equals(InventorySlot.BOOTS)) {
            equipmentSlot = class_1304.field_6166;
        } else {
            return null;
        }
        @Nullable class_1799 item = player.method_6118(equipmentSlot);
        if (item == null || item.method_7960()) {
            return null;
        }
        return MinecraftServerAudiences.of((MinecraftServer)player.method_51469().method_8503()).asAdventure(item.method_7954());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player().map(player -> Permissions.check((class_1297)player, (String)permission, (int)player.method_51469().method_8503().method_3798())).orElse(false);
    }

    @Override
    public String primaryGroup() {
        if (!((CarbonChatFabric)this.carbonChatFabric.get()).luckPermsLoaded()) {
            return "default";
        }
        return super.primaryGroup();
    }

    @Override
    public List<String> groups() {
        if (!((CarbonChatFabric)this.carbonChatFabric.get()).luckPermsLoaded()) {
            return List.of("default");
        }
        return super.groups();
    }

    @Override
    protected Optional<Component> platformDisplayName() {
        return this.player().flatMap(p -> p.get(Identity.DISPLAY_NAME));
    }
}

