/*
 * Decompiled with CFR 0.152.
 */
package net.draycia.carbon.fabric.users;

import carbonchat.libs.com.google.inject.Inject;
import carbonchat.libs.com.google.inject.Singleton;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.NonNull;
import carbonchat.libs.org.checkerframework.checker.nullness.qual.Nullable;
import carbonchat.libs.org.checkerframework.framework.qual.DefaultQualifier;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.draycia.carbon.common.users.MojangProfileResolver;
import net.draycia.carbon.common.users.ProfileResolver;
import net.draycia.carbon.fabric.MinecraftServerHolder;
import net.minecraft.class_3222;

@Singleton
@DefaultQualifier(value=NonNull.class)
public final class FabricProfileResolver
implements ProfileResolver {
    private final MinecraftServerHolder serverHolder;
    private final ProfileResolver mojang;

    @Inject
    private FabricProfileResolver(MinecraftServerHolder serverHolder, MojangProfileResolver mojang) {
        this.serverHolder = serverHolder;
        this.mojang = mojang;
    }

    @Override
    public CompletableFuture<@Nullable UUID> resolveUUID(String username, boolean cacheOnly) {
        @Nullable class_3222 online = this.serverHolder.requireServer().method_3760().method_14566(username);
        if (online != null) {
            return CompletableFuture.completedFuture(online.method_5667());
        }
        return this.mojang.resolveUUID(username, cacheOnly);
    }

    @Override
    public CompletableFuture<@Nullable String> resolveName(UUID uuid, boolean cacheOnly) {
        @Nullable class_3222 online = this.serverHolder.requireServer().method_3760().method_14602(uuid);
        if (online != null) {
            return CompletableFuture.completedFuture(online.method_7334().name());
        }
        return this.mojang.resolveName(uuid, cacheOnly);
    }

    @Override
    public void shutdown() {
        this.mojang.shutdown();
    }
}

