/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.mixin.client;

import net.dillon.survivalfly.keybind.ModKeybinds;
import net.dillon.survivalfly.main.SurvivalFly;
import net.dillon.survivalfly.option.ChangeFlySpeedOnRule;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.packet.ServerHandler;
import net.dillon.survivalfly.packet.UpdateFlightSpeedC2SPayload;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={MouseHandler.class})
public class MouseMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Redirect(method={"onScroll"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;isSpectator()Z"))
    private boolean allowAnyGamemode(LocalPlayer clientPlayer) {
        if (clientPlayer.getAbilities().mayfly) {
            if (!ModKeybinds.CHANGE_FLIGHT_SPEED.isDown()) {
                return clientPlayer.isSpectator();
            }
            if (((ChangeFlySpeedOnRule)((Object)ModOptions.CHANGE_FLY_SPEED_ON_RULE.get())).nonSurvivalLikeGamemodes()) {
                return clientPlayer.isSpectator() || clientPlayer.isCreative();
            }
            if (((ChangeFlySpeedOnRule)((Object)ModOptions.CHANGE_FLY_SPEED_ON_RULE.get())).anyGamemode()) {
                return true;
            }
        }
        return clientPlayer.isSpectator();
    }

    @Inject(method={"onScroll"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Abilities;setFlyingSpeed(F)V", shift=At.Shift.AFTER)})
    private void updateFlightSpeed(long window, double horizontal, double vertical, CallbackInfo ci) {
        float speed = this.minecraft.player.getAbilities().getFlyingSpeed();
        ServerHandler.sendToServer(new UpdateFlightSpeedC2SPayload(speed));
        this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"survivalfly.current_flight_speed", (Object[])new Object[]{SurvivalFly.decimalAsPercentage(speed)}).withStyle(ChatFormatting.GREEN).append("%"), true);
    }
}

