/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.util;

import javax.annotation.Nullable;
import net.dillon.survivalfly.screen.ModOptionsScreen;
import net.dillon.survivalfly.util.ModTexts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonUtil {
    public static Button initializeButton(Minecraft client, Screen parent, int width, int height) {
        return new Button.Builder(ModTexts.BLANK, button -> client.setScreen((Screen)new ModOptionsScreen(parent))).bounds(width, height, 20, 20).build();
    }

    public static void drawTooltipAndTexture(GuiGraphics context, Font renderer, Button button, int mouseX, int mouseY, @Nullable Float f) {
        if (button.isHovered()) {
            ButtonUtil.drawTooltip(context, renderer, mouseX, mouseY);
        }
        ButtonUtil.drawTexture(context, button, f == null ? 1.0f : f.floatValue());
    }

    private static void drawTooltip(GuiGraphics context, Font renderer, int mouseX, int mouseY) {
        context.renderTooltip(renderer, renderer.split((FormattedText)Component.translatable((String)"survivalfly.gui.options.tooltip"), 200), mouseX, mouseY);
    }

    private static void drawTexture(GuiGraphics context, Button button, float f) {
        context.blit(ResourceLocation.parse((String)"survivalfly:textures/gui/survivalflyelytra.png"), button.getX() + 1, button.getY() + 1, 0.0f, 0.0f, 18, 18, 18, 18);
    }
}

