/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.main;

import com.mojang.brigadier.CommandDispatcher;
import net.dillon.survivalfly.command.FlightCommand;
import net.dillon.survivalfly.command.FlightSpeedCommand;
import net.dillon.survivalfly.command.FlightStatusCommand;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.option.PermissionLevel;
import net.dillon.survivalfly.packet.UpdateFlightSpeedC2SPayload;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurvivalFly
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Survival Fly");
    public static final float DEFAULT_FLIGHT_SPEED = 0.05f;

    public void onInitialize() {
        if (SurvivalFly.options().permissionLevel == null) {
            SurvivalFly.warn("Permission level is somehow null, fixing.");
            SurvivalFly.options().permissionLevel = PermissionLevel.REGULAR;
            ModOptions.saveConfig();
        }
        ModOptions.loadConfig();
        SurvivalFly.registerPayloads();
        SurvivalFly.registerCommands();
        SurvivalFly.info("Initialized Survival Fly mod successfully!");
    }

    private static void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(UpdateFlightSpeedC2SPayload.PAYLOAD_ID, UpdateFlightSpeedC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(UpdateFlightSpeedC2SPayload.PAYLOAD_ID, (payload, context) -> {
            class_3222 player = context.player();
            float speed = payload.speed();
            player.method_31549().method_7248(speed);
            player.method_7355();
        });
    }

    private static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> FlightCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> FlightSpeedCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> FlightStatusCommand.register((CommandDispatcher<class_2168>)commandDispatcher));
    }

    public static ModOptions options() {
        return ModOptions.OPTIONS;
    }

    public static void info(String message) {
        LOGGER.info(message);
    }

    public static void warn(String message) {
        LOGGER.warn(message);
    }

    public static class_2561 statusText(class_3222 player, boolean isFirstLetterLowercase) {
        return isFirstLetterLowercase ? (player.method_31549().field_7478 ? class_2561.method_43471((String)"survivalfly.enabled.lowercase").method_27692(class_124.field_1060) : class_2561.method_43471((String)"survivalfly.disabled.lowercase").method_27692(class_124.field_1061)) : (player.method_31549().field_7478 ? class_2561.method_43471((String)"survivalfly.enabled").method_27692(class_124.field_1060) : class_2561.method_43471((String)"survivalfly.disabled").method_27692(class_124.field_1061));
    }

    public static float percentageAsDecimal(float speed) {
        return speed / 100.0f * 0.2f;
    }

    public static int decimalAsPercentage(float speed) {
        return Math.round(speed / 0.2f * 100.0f);
    }
}

