/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.option;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.dillon.survivalfly.option.ChangeFlySpeedOnRule;
import net.dillon.survivalfly.option.PermissionLevel;
import net.fabricmc.loader.api.FabricLoader;

public class ModOptions {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    public static final String CONFIG = "survivalfly-config.json";
    private static File file;
    public static ModOptions OPTIONS;
    public PermissionLevel permissionLevel = PermissionLevel.REGULAR;
    public ChangeFlySpeedOnRule changeFlySpeedOnRule = ChangeFlySpeedOnRule.ANY_GAMEMODE;
    public boolean showConfigButton = true;

    public static void loadConfig() {
        File configFile = ModOptions.getConfigFile();
        if (!configFile.exists()) {
            OPTIONS = new ModOptions();
        } else {
            ModOptions.readConfig();
        }
        ModOptions.saveConfig();
    }

    public static void readConfig() {
        OPTIONS = ModOptions.getConfig();
    }

    public static void saveConfig() {
        File file = ModOptions.getConfigFile();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(GSON.toJson((Object)OPTIONS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setConfig(ModOptions config) {
        OPTIONS = config;
        ModOptions.saveConfig();
    }

    public static ModOptions getConfig() {
        ModOptions modOptions;
        File file = ModOptions.getConfigFile();
        FileReader reader = new FileReader(file);
        try {
            modOptions = (ModOptions)GSON.fromJson((Reader)reader, ModOptions.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ModOptions newconfig = new ModOptions();
                ModOptions.setConfig(newconfig);
                return newconfig;
            }
        }
        reader.close();
        return modOptions;
    }

    public static File getConfigFile() {
        if (file == null) {
            file = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG);
        }
        return file;
    }

    static {
        OPTIONS = ModOptions.getConfig();
    }
}

