/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.dillon.survivalfly.main.SurvivalFly;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.option.PermissionLevel;
import net.dillon.survivalfly.util.PlayerAbilitiesExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalfly", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent dispatcher) {
        dispatcher.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"flight").requires(source -> source.m_6761_(((PermissionLevel)((Object)((Object)ModOptions.PERMISSION_LEVEL.get()))).m_35965_()))).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), !((CommandSourceStack)context.getSource()).m_81375_().m_150110_().f_35936_))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), !((CommandSourceStack)context.getSource()).m_81375_().m_150110_().f_35936_)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"enable").executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), true))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"target"), true))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"disable").executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), false))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"target"), false)))));
    }

    private static void sendFeedback(CommandSourceStack source, ServerPlayer player, boolean success) {
        if (source.m_81373_() == player) {
            if (success) {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_changed.self", (Object[])new Object[]{SurvivalFly.statusText(player, false)}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.cannot_change_flight.self", (Object[])new Object[]{player.f_8941_.m_9290_().m_46405_()}), true);
            }
        } else {
            if (source.m_81372_().m_46469_().m_46207_(GameRules.f_46144_) && success) {
                player.m_213846_((Component)Component.m_237110_((String)"survivalfly.flight_changed", (Object[])new Object[]{SurvivalFly.statusText(player, true)}));
            }
            if (success) {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_changed.other", (Object[])new Object[]{SurvivalFly.statusText(player, false), player.m_5446_()}), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.cannot_change_flight.other", (Object[])new Object[]{player.m_5446_(), player.f_8941_.m_9290_().m_46405_()}), true);
            }
        }
    }

    private static int execute(CommandSourceStack context, Collection<ServerPlayer> targets, boolean value) {
        int i = 0;
        for (ServerPlayer player : targets) {
            if (!player.f_8941_.m_9290_().m_46408_() && player.f_8941_.m_9290_() != GameType.SPECTATOR) {
                if (player.m_150110_().f_35936_ != value) {
                    player.m_150110_().f_35936_ = value;
                    ((PlayerAbilitiesExtension)player.m_150110_()).setEverEnabledFlight(value);
                    if (player.m_150110_().f_35935_ && !player.m_150110_().f_35936_) {
                        player.m_150110_().f_35935_ = false;
                    }
                    player.m_6885_();
                    FlightCommand.sendFeedback(context, player, true);
                    ++i;
                    continue;
                }
                if (context.m_81373_() == player) {
                    context.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_is_the_same", (Object[])new Object[]{SurvivalFly.statusText(player, true)}), true);
                    continue;
                }
                context.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_is_the_same.other", (Object[])new Object[]{player.m_5446_(), SurvivalFly.statusText(player, true)}), true);
                continue;
            }
            FlightCommand.sendFeedback(context, player, false);
        }
        return i;
    }
}

