/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.dillon.survivalfly.main.SurvivalFly;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.option.PermissionLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalfly", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightSpeedCommand {
    private static final String SPEED_ARGUMENT_NAME = "speed (as percentage)";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent dispatcher) {
        dispatcher.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"flightspeed").requires(source -> source.m_6761_(((PermissionLevel)((Object)((Object)ModOptions.PERMISSION_LEVEL.get()))).m_35965_()))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)SPEED_ARGUMENT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), SurvivalFly.percentageAsDecimal(IntegerArgumentType.getInteger((CommandContext)context, (String)SPEED_ARGUMENT_NAME))))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"target"), SurvivalFly.percentageAsDecimal(IntegerArgumentType.getInteger((CommandContext)context, (String)SPEED_ARGUMENT_NAME)))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"get").executes(context -> FlightSpeedCommand.getSpeed((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FlightSpeedCommand.getSpeed((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).m_81375_()), 0.05f))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"target"), 0.05f)))));
    }

    private static void tellSpeed(CommandSourceStack source, ServerPlayer player, float speed) {
        if (source.m_81373_() == player) {
            source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_speed", (Object[])new Object[]{Float.valueOf(speed)}).m_130946_("%."), true);
        } else {
            source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_speed.other", (Object[])new Object[]{player.m_5446_(), Float.valueOf(speed)}).m_130946_("%."), true);
        }
    }

    private static int getSpeed(CommandSourceStack context, ServerPlayer target) {
        FlightSpeedCommand.tellSpeed(context, target, SurvivalFly.decimalAsPercentage(target.m_150110_().m_35942_()));
        return 0;
    }

    private static void sendSuccess(CommandSourceStack source, ServerPlayer player, boolean success, float speed) {
        if (source.m_81373_() == player) {
            if (success) {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_speed_changed.self", (Object[])new Object[]{Float.valueOf(speed)}).m_130946_("%."), true);
            } else {
                source.m_288197_(() -> Component.m_237115_((String)"survivalfly.cannot_change_flight_speed.self"), true);
            }
        } else {
            if (source.m_81372_().m_46469_().m_46207_(GameRules.f_46144_) && success) {
                player.m_213846_((Component)Component.m_237110_((String)"survivalfly.flight_speed_changed", (Object[])new Object[]{Float.valueOf(speed)}).m_130946_("%."));
            }
            if (success) {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.flight_speed_changed.other", (Object[])new Object[]{player.m_5446_(), Float.valueOf(speed)}).m_130946_("%."), true);
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"survivalfly.cannot_change_flight_speed.other", (Object[])new Object[]{player.m_5446_(), player.f_8941_.m_9290_().m_46405_()}), true);
            }
        }
    }

    private static int execute(CommandSourceStack context, Collection<ServerPlayer> targets, float speed) {
        int i = 0;
        for (ServerPlayer player : targets) {
            if (player.m_150110_().f_35936_) {
                player.m_150110_().m_35943_(speed);
                player.m_6885_();
                FlightSpeedCommand.sendSuccess(context, player, true, SurvivalFly.decimalAsPercentage(speed));
                ++i;
                continue;
            }
            FlightSpeedCommand.sendSuccess(context, player, false, SurvivalFly.decimalAsPercentage(speed));
        }
        return i;
    }
}

