/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.main;

import com.mojang.logging.LogUtils;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.packet.ServerHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="survivalfly")
public final class SurvivalFly {
    public static final String MOD_ID = "survivalfly";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float DEFAULT_FLIGHT_SPEED = 0.05f;

    public SurvivalFly(FMLJavaModLoadingContext context) {
        IEventBus modBusGroup = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModOptions.SPEC);
        modBusGroup.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ServerHandler::registerUpdateFlightSpeedC2SPayload);
    }

    public static void info(String message) {
        LOGGER.info(message);
    }

    public static void warn(String message) {
        LOGGER.warn(message);
    }

    public static Component statusText(ServerPlayer player, boolean isFirstLetterLowercase) {
        return isFirstLetterLowercase ? (player.m_150110_().f_35936_ ? Component.m_237115_((String)"survivalfly.enabled.lowercase").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"survivalfly.disabled.lowercase").m_130940_(ChatFormatting.RED)) : (player.m_150110_().f_35936_ ? Component.m_237115_((String)"survivalfly.enabled").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"survivalfly.disabled").m_130940_(ChatFormatting.RED));
    }

    public static float percentageAsDecimal(float speed) {
        return speed / 100.0f * 0.2f;
    }

    public static int decimalAsPercentage(float speed) {
        return Math.round(speed / 0.2f * 100.0f);
    }

    @Mod.EventBusSubscriber(modid="survivalfly", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

