/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.dillon.survivalfly.main.SurvivalFly;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.option.PermissionLevel;
import net.dillon.survivalfly.util.PlayerAbilitiesExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalfly", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent dispatcher) {
        dispatcher.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"flight").requires(source -> source.hasPermission(((PermissionLevel)((Object)((Object)ModOptions.PERMISSION_LEVEL.get()))).getId()))).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), !((CommandSourceStack)context.getSource()).getPlayerOrException().getAbilities().mayfly))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), !((CommandSourceStack)context.getSource()).getPlayerOrException().getAbilities().mayfly)))).then(((LiteralArgumentBuilder)Commands.literal((String)"enable").executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), true))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"target"), true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"disable").executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), false))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> FlightCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"target"), false)))));
    }

    private static void sendFeedback(CommandSourceStack source, ServerPlayer player, boolean success) {
        if (source.getEntity() == player) {
            if (success) {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_changed.self", (Object[])new Object[]{SurvivalFly.statusText(player, false)}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.cannot_change_flight.self", (Object[])new Object[]{player.gameMode.getGameModeForPlayer().getName()}), true);
            }
        } else {
            if (source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && success) {
                player.sendSystemMessage((Component)Component.translatable((String)"survivalfly.flight_changed", (Object[])new Object[]{SurvivalFly.statusText(player, true)}));
            }
            if (success) {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_changed.other", (Object[])new Object[]{SurvivalFly.statusText(player, false), player.getDisplayName()}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.cannot_change_flight.other", (Object[])new Object[]{player.getDisplayName(), player.gameMode.getGameModeForPlayer().getName()}), true);
            }
        }
    }

    private static int execute(CommandSourceStack context, Collection<ServerPlayer> targets, boolean value) {
        int i = 0;
        for (ServerPlayer player : targets) {
            if (!player.gameMode.getGameModeForPlayer().isCreative() && player.gameMode.getGameModeForPlayer() != GameType.SPECTATOR) {
                if (player.getAbilities().mayfly != value) {
                    player.getAbilities().mayfly = value;
                    ((PlayerAbilitiesExtension)player.getAbilities()).setEverEnabledFlight(value);
                    if (player.getAbilities().flying && !player.getAbilities().mayfly) {
                        player.getAbilities().flying = false;
                    }
                    player.onUpdateAbilities();
                    FlightCommand.sendFeedback(context, player, true);
                    ++i;
                    continue;
                }
                if (context.getEntity() == player) {
                    context.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_is_the_same", (Object[])new Object[]{SurvivalFly.statusText(player, true)}), true);
                    continue;
                }
                context.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_is_the_same.other", (Object[])new Object[]{player.getDisplayName(), SurvivalFly.statusText(player, true)}), true);
                continue;
            }
            FlightCommand.sendFeedback(context, player, false);
        }
        return i;
    }
}

