/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.dillon.survivalfly.main.SurvivalFly;
import net.dillon.survivalfly.option.ModOptions;
import net.dillon.survivalfly.option.PermissionLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalfly", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightSpeedCommand {
    private static final String SPEED_ARGUMENT_NAME = "speed (as percentage)";

    @SubscribeEvent
    public static void register(RegisterCommandsEvent dispatcher) {
        dispatcher.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"flightspeed").requires(source -> source.hasPermission(((PermissionLevel)((Object)((Object)ModOptions.PERMISSION_LEVEL.get()))).getId()))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)SPEED_ARGUMENT_NAME, (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), SurvivalFly.percentageAsDecimal(IntegerArgumentType.getInteger((CommandContext)context, (String)SPEED_ARGUMENT_NAME))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"target"), SurvivalFly.percentageAsDecimal(IntegerArgumentType.getInteger((CommandContext)context, (String)SPEED_ARGUMENT_NAME)))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"get").executes(context -> FlightSpeedCommand.getSpeed((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> FlightSpeedCommand.getSpeed((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), List.of(((CommandSourceStack)context.getSource()).getPlayerOrException()), 0.05f))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(context -> FlightSpeedCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"target"), 0.05f)))));
    }

    private static void tellSpeed(CommandSourceStack source, ServerPlayer player, float speed) {
        if (source.getEntity() == player) {
            source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_speed", (Object[])new Object[]{Float.valueOf(speed)}).append("%."), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_speed.other", (Object[])new Object[]{player.getDisplayName(), Float.valueOf(speed)}).append("%."), true);
        }
    }

    private static int getSpeed(CommandSourceStack context, ServerPlayer target) {
        FlightSpeedCommand.tellSpeed(context, target, SurvivalFly.decimalAsPercentage(target.getAbilities().getFlyingSpeed()));
        return 0;
    }

    private static void sendSuccess(CommandSourceStack source, ServerPlayer player, boolean success, float speed) {
        if (source.getEntity() == player) {
            if (success) {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_speed_changed.self", (Object[])new Object[]{Float.valueOf(speed)}).append("%."), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.cannot_change_flight_speed.self"), true);
            }
        } else {
            if (source.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK) && success) {
                player.sendSystemMessage((Component)Component.translatable((String)"survivalfly.flight_speed_changed", (Object[])new Object[]{Float.valueOf(speed)}).append("%."));
            }
            if (success) {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_speed_changed.other", (Object[])new Object[]{player.getDisplayName(), Float.valueOf(speed)}).append("%."), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.cannot_change_flight_speed.other", (Object[])new Object[]{player.getDisplayName(), player.gameMode.getGameModeForPlayer().getName()}), true);
            }
        }
    }

    private static int execute(CommandSourceStack context, Collection<ServerPlayer> targets, float speed) {
        int i = 0;
        for (ServerPlayer player : targets) {
            if (player.getAbilities().mayfly) {
                player.getAbilities().setFlyingSpeed(speed);
                player.onUpdateAbilities();
                FlightSpeedCommand.sendSuccess(context, player, true, SurvivalFly.decimalAsPercentage(speed));
                ++i;
                continue;
            }
            FlightSpeedCommand.sendSuccess(context, player, false, SurvivalFly.decimalAsPercentage(speed));
        }
        return i;
    }
}

