/*
 * Decompiled with CFR 0.152.
 */
package net.dillon.survivalfly.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.dillon.survivalfly.main.SurvivalFly;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivalfly", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlightStatusCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent dispatcher) {
        dispatcher.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"flightstatus").requires(serverCommandSource -> serverCommandSource.hasPermission(0))).executes(context -> FlightStatusCommand.execute((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).getPlayerOrException()))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> FlightStatusCommand.execute((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))));
    }

    private static void sendSuccess(CommandSourceStack source, ServerPlayer player, boolean success) {
        if (source.getEntity() == player) {
            if (success) {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_status", (Object[])new Object[]{SurvivalFly.statusText(player, true)}), true);
            } else {
                source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_status.flying_gamemode", (Object[])new Object[]{player.gameMode.getGameModeForPlayer().getName()}), true);
            }
        } else if (success) {
            source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_status.other", (Object[])new Object[]{player.getDisplayName(), SurvivalFly.statusText(player, true)}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"survivalfly.flight_status.flying_gamemode.other", (Object[])new Object[]{player.getDisplayName(), player.gameMode.getGameModeForPlayer().getName()}), true);
        }
    }

    private static int execute(CommandSourceStack context, ServerPlayer target) {
        if (target.gameMode.getGameModeForPlayer().isCreative() || target.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
            FlightStatusCommand.sendSuccess(context, target, false);
            return 0;
        }
        FlightStatusCommand.sendSuccess(context, target, true);
        return 1;
    }
}

