/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.block;

import net.mde.duneons.init.DuneonsModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AzureCrystalBlock
extends FlowerBlock {
    public AzureCrystalBlock() {
        super(MobEffects.MOVEMENT_SPEED, 100.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_CYAN).sound(SoundType.AMETHYST).strength(1.3f, 2.0f).hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).lightLevel(s -> 7).noOcclusion().dynamicShape().offsetType(BlockBehaviour.OffsetType.NONE).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return AzureCrystalBlock.box((double)0.0, (double)0.0, (double)0.0, (double)12.8, (double)17.0, (double)12.8).move(offset.x, offset.y, offset.z);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)DuneonsModBlocks.CRYSTALBLUE.get());
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is(Blocks.STONE) || groundState.is(Blocks.GRANITE) || groundState.is(Blocks.DIORITE) || groundState.is(Blocks.ANDESITE) || groundState.is(Blocks.DEEPSLATE) || groundState.is(Blocks.DEEPSLATE_TILES) || groundState.is(Blocks.CRACKED_DEEPSLATE_TILES) || groundState.is(Blocks.CALCITE) || groundState.is(Blocks.DRIPSTONE_BLOCK) || groundState.is((Block)DuneonsModBlocks.DARK_DIRT_PEBBLESCAVE.get()) || groundState.is((Block)DuneonsModBlocks.MOSSYCOBBLESTONE.get()) || groundState.is((Block)DuneonsModBlocks.MOSSSTONEBLOCK.get()) || groundState.is((Block)DuneonsModBlocks.MOSSYSTONE.get()) || groundState.is((Block)DuneonsModBlocks.CREEPERWOODSMOSS.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }
}

