/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.block;

import net.mde.duneons.init.DuneonsModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LichenStalksBlock
extends FlowerBlock {
    public LichenStalksBlock() {
        super(MobEffects.SATURATION, 0.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Shapes.or((VoxelShape)LichenStalksBlock.box((double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{LichenStalksBlock.box((double)3.0, (double)15.0, (double)11.0, (double)5.0, (double)17.0, (double)13.0), LichenStalksBlock.box((double)11.0, (double)0.0, (double)2.0, (double)15.0, (double)21.0, (double)6.0), LichenStalksBlock.box((double)11.0, (double)21.0, (double)2.0, (double)15.0, (double)25.0, (double)6.0)}).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is(Blocks.GRASS_BLOCK) || groundState.is((Block)DuneonsModBlocks.ENDMESHFADESGRASS.get()) || groundState.is((Block)DuneonsModBlocks.ENDMESHFADESSTONEGRASSSTONES.get()) || groundState.is(Blocks.END_STONE) || groundState.is(Blocks.COARSE_DIRT) || groundState.is(Blocks.DIRT);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }
}

