/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipefungusBlock
extends FlowerBlock {
    public PipefungusBlock() {
        super(MobEffects.SATURATION, 0.0f, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).sound(SoundType.FUNGUS).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Shapes.or((VoxelShape)PipefungusBlock.box((double)11.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{PipefungusBlock.box((double)10.0, (double)16.0, (double)2.0, (double)16.0, (double)18.0, (double)8.0), PipefungusBlock.box((double)8.0, (double)0.0, (double)11.0, (double)12.0, (double)8.0, (double)15.0), PipefungusBlock.box((double)7.0, (double)8.0, (double)10.0, (double)13.0, (double)10.0, (double)16.0), PipefungusBlock.box((double)2.0, (double)23.0, (double)4.0, (double)8.0, (double)25.0, (double)10.0), PipefungusBlock.box((double)3.0, (double)0.0, (double)5.0, (double)7.0, (double)8.0, (double)9.0), PipefungusBlock.box((double)3.0, (double)8.0, (double)5.0, (double)7.0, (double)16.0, (double)9.0), PipefungusBlock.box((double)3.0, (double)16.0, (double)5.0, (double)7.0, (double)24.0, (double)9.0)}).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    private boolean canPlantTypeSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return state.isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        BlockPos posbelow = pos.below();
        BlockState statebelow = world.getBlockState(posbelow);
        if (blockstate.getBlock() == this) {
            return this.canPlantTypeSurvive(statebelow, world, posbelow);
        }
        return this.mayPlaceOn(statebelow, (BlockGetter)world, posbelow);
    }
}

