/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.block;

import net.mde.duneons.init.DuneonsModBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

public class Sand3Block
extends FlowerBlock {
    public Sand3Block() {
        super(MobEffects.SATURATION, 0.0f, BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.SAND).instabreak().noOcclusion().dynamicShape().replaceable().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Vec3 offset = state.getOffset(world, pos);
        return Sand3Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0).move(offset.x, offset.y, offset.z);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Blocks.AIR);
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is(Blocks.SANDSTONE) || groundState.is(Blocks.SMOOTH_SANDSTONE) || groundState.is(Blocks.SAND) || groundState.is((Block)DuneonsModBlocks.SANDNAUTIUS.get()) || groundState.is((Block)DuneonsModBlocks.SANDERCOBBLE.get()) || groundState.is((Block)DuneonsModBlocks.SANDCOBBLESTONE.get()) || groundState.is((Block)DuneonsModBlocks.SANDYGRAVEL.get()) || groundState.is(Blocks.DIRT) || groundState.is(Blocks.COARSE_DIRT) || groundState.is(Blocks.PODZOL) || groundState.is((Block)DuneonsModBlocks.MOSSDIRTPUMPKIN.get()) || groundState.is((Block)DuneonsModBlocks.SANDDIRT.get()) || groundState.is((Block)DuneonsModBlocks.COARSEDIRT_2.get()) || groundState.is((Block)DuneonsModBlocks.MELONDIRT.get()) || groundState.is((Block)DuneonsModBlocks.DUNGEONSCHARREDDIRT.get()) || groundState.is((Block)DuneonsModBlocks.MOSSYGRASSBAMBOO.get()) || groundState.is((Block)DuneonsModBlocks.MESSAGRASS.get()) || groundState.is((Block)DuneonsModBlocks.BAMBOOGRASS.get()) || groundState.is((Block)DuneonsModBlocks.SWAMPGRASSSIDE.get()) || groundState.is(Blocks.GRASS_BLOCK) || groundState.is((Block)DuneonsModBlocks.PUMPKINGRASSBLOCK.get()) || groundState.is((Block)DuneonsModBlocks.GRASSMOSS.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blockColorLoad(RegisterColorHandlersEvent.Block event) {
        event.getBlockColors().register((bs, world, pos, index) -> world != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)DuneonsModBlocks.SAND_3.get()});
    }
}

