/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class Modelirongolem<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"modelirongolem"), "main");
    public final ModelPart golem;
    public final ModelPart leg0;
    public final ModelPart leg0_b;
    public final ModelPart leg1;
    public final ModelPart leg1_b;
    public final ModelPart upperBody;
    public final ModelPart head;
    public final ModelPart arm0;
    public final ModelPart arm1;

    public Modelirongolem(ModelPart root) {
        this.golem = root.getChild("golem");
        this.leg0 = this.golem.getChild("leg0");
        this.leg0_b = this.leg0.getChild("leg0_b");
        this.leg1 = this.golem.getChild("leg1");
        this.leg1_b = this.leg1.getChild("leg1_b");
        this.upperBody = this.golem.getChild("upperBody");
        this.head = this.upperBody.getChild("head");
        this.arm0 = this.upperBody.getChild("arm0");
        this.arm1 = this.upperBody.getChild("arm1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition golem = partdefinition.addOrReplaceChild("golem", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition leg0 = golem.addOrReplaceChild("leg0", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)18.0f, (float)0.0f));
        PartDefinition leg0_b = leg0.addOrReplaceChild("leg0_b", CubeListBuilder.create().texOffs(37, 0).addBox(-3.0f, -16.0f, -2.5f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)13.0f, (float)-0.5f));
        PartDefinition leg1 = golem.addOrReplaceChild("leg1", CubeListBuilder.create(), PartPose.offset((float)5.0f, (float)18.0f, (float)0.0f));
        PartDefinition leg1_b = leg1.addOrReplaceChild("leg1_b", CubeListBuilder.create().texOffs(60, 0).addBox(-3.0f, -16.0f, -2.5f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)13.0f, (float)-0.5f));
        PartDefinition upperBody = golem.addOrReplaceChild("upperBody", CubeListBuilder.create().texOffs(0, 70).addBox(-4.5f, -5.5f, -3.0f, 9.0f, 5.0f, 6.0f, new CubeDeformation(0.5f)).texOffs(0, 40).addBox(-9.0f, -17.5f, -6.0f, 18.0f, 12.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)15.5f, (float)0.0f));
        PartDefinition head = upperBody.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -5.5f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(24, 0).addBox(-1.0f, -5.0f, -7.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.5f, (float)-2.0f));
        PartDefinition arm0 = upperBody.addOrReplaceChild("arm0", CubeListBuilder.create().texOffs(60, 21).addBox(-13.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.5f, (float)0.0f));
        PartDefinition arm1 = upperBody.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(60, 58).addBox(9.0f, -2.5f, -3.0f, 4.0f, 30.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.5f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.golem.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.upperBody.yRot = netHeadYaw / 57.295776f;
        this.upperBody.xRot = headPitch / 57.295776f;
    }
}

