/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelsheep<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"duneons", (String)"modelsheep"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart leg1;
    public final ModelPart leg2;
    public final ModelPart leg3;
    public final ModelPart leg4;

    public Modelsheep(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.leg1 = root.getChild("leg1");
        this.leg2 = root.getChild("leg2");
        this.leg3 = root.getChild("leg3");
        this.leg4 = root.getChild("leg4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)10.0f, (float)-1.0f));
        PartDefinition rotation = body.addOrReplaceChild("rotation", CubeListBuilder.create().texOffs(24, 0).addBox(-4.0f, -10.0f, -7.0f, 8.0f, 16.0f, 6.0f, new CubeDeformation(1.75f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)3.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.6f)), PartPose.offset((float)0.0f, (float)6.0f, (float)-8.0f));
        PartDefinition head2 = head.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(65, 1).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(17, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        PartDefinition leg8 = leg1.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(65, 31).addBox(-8.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        PartDefinition leg7 = leg2.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(65, 47).addBox(4.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(17, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        PartDefinition leg6 = leg3.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(65, 31).addBox(-8.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)6.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(17, 22).addBox(-2.0f, 0.11f, -1.85f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        PartDefinition leg5 = leg4.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(65, 31).addBox(4.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay);
        this.head.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg1.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg2.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg3.render(poseStack, buffer, packedLight, packedOverlay);
        this.leg4.render(poseStack, buffer, packedLight, packedOverlay);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

