/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import net.mde.duneons.client.model.Modelchef;
import net.mde.duneons.client.model.animations.chefAnimation;
import net.mde.duneons.entity.ChefEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ChefRenderer
extends MobRenderer<ChefEntity, Modelchef<ChefEntity>> {
    public ChefRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelchef.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(ChefEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/chef_illager.png");
    }

    private static final class AnimatedModel
    extends Modelchef<ChefEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<ChefEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(ChefEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, chefAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(chefAnimation.walk, limbSwing, limbSwingAmount, 1.2f, 1.0f);
                this.animate(entity.animationState2, chefAnimation.run, ageInTicks, 1.1f);
                this.animate(entity.animationState3, chefAnimation.attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(ChefEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

