/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import net.mde.duneons.client.model.Modelenderman;
import net.mde.duneons.client.model.animations.endermanAnimation;
import net.mde.duneons.entity.EndermenbossEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EndermenbossRenderer
extends MobRenderer<EndermenbossEntity, Modelenderman<EndermenbossEntity>> {
    public EndermenbossRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelenderman.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(EndermenbossEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/enderman.png");
    }

    private static final class AnimatedModel
    extends Modelenderman<EndermenbossEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<EndermenbossEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(EndermenbossEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, endermanAnimation.idle, ageInTicks, 1.0f);
                this.animate(entity.animationState1, endermanAnimation.attack, ageInTicks, 1.0f);
                this.animateWalk(endermanAnimation.walk, limbSwing, limbSwingAmount, 2.3f, 1.0f);
                this.animate(entity.animationState3, endermanAnimation.scary, ageInTicks, 1.1f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(EndermenbossEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

