/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import net.mde.duneons.client.model.Modelirongolem;
import net.mde.duneons.client.model.animations.irongolemAnimation;
import net.mde.duneons.entity.IrongolemEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class IrongolemRenderer
extends MobRenderer<IrongolemEntity, Modelirongolem<IrongolemEntity>> {
    public IrongolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelirongolem.LAYER_LOCATION)), 0.7f);
    }

    public ResourceLocation getTextureLocation(IrongolemEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/iron_golem.png");
    }

    private static final class AnimatedModel
    extends Modelirongolem<IrongolemEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<IrongolemEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(IrongolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, irongolemAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(irongolemAnimation.walk, limbSwing, limbSwingAmount, 1.2f, 1.0f);
                this.animate(entity.animationState2, irongolemAnimation.swing, ageInTicks, 1.0f);
                this.animate(entity.animationState3, irongolemAnimation.swing2, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(IrongolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

