/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mde.duneons.client.model.Modelkeygolem;
import net.mde.duneons.client.model.animations.keygolemAnimation;
import net.mde.duneons.entity.KeygolemEntity;
import net.mde.duneons.procedures.KeygolemDisplayConditionProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class KeygolemRenderer
extends MobRenderer<KeygolemEntity, Modelkeygolem<KeygolemEntity>> {
    public KeygolemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelkeygolem.LAYER_LOCATION)), 0.4f);
        this.addLayer((RenderLayer)new RenderLayer<KeygolemEntity, Modelkeygolem<KeygolemEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"duneons:textures/entities/babykey_duamond.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, KeygolemEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (KeygolemDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelkeygolem)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(KeygolemEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/babykey_gold.png");
    }

    private static final class AnimatedModel
    extends Modelkeygolem<KeygolemEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<KeygolemEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(KeygolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, keygolemAnimation.idle, ageInTicks, 1.1f);
                this.animateWalk(keygolemAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(KeygolemEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

