/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mde.duneons.client.model.Modeldrowneds;
import net.mde.duneons.client.model.animations.drownedAnimation;
import net.mde.duneons.entity.RiseDrownedEntity;
import net.mde.duneons.procedures.RiseDrownedDisplayConditionColdtridentProcedure;
import net.mde.duneons.procedures.RiseDrownedDisplayConditionSkinProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RiseDrownedRenderer
extends MobRenderer<RiseDrownedEntity, Modeldrowneds<RiseDrownedEntity>> {
    public RiseDrownedRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeldrowneds.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<RiseDrownedEntity, Modeldrowneds<RiseDrownedEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"duneons:textures/entities/drowned_variant2.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RiseDrownedEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (RiseDrownedDisplayConditionSkinProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeldrowneds)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<RiseDrownedEntity, Modeldrowneds<RiseDrownedEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"duneons:textures/entities/drowned_variant2_trident.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RiseDrownedEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (RiseDrownedDisplayConditionColdtridentProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modeldrowneds)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(RiseDrownedEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/drowned_variant1.png");
    }

    private static final class AnimatedModel
    extends Modeldrowneds<RiseDrownedEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RiseDrownedEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RiseDrownedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, drownedAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(drownedAnimation.walk, limbSwing, limbSwingAmount, 1.1f, 1.0f);
                this.animate(entity.animationState2, drownedAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState3, drownedAnimation.hurt, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RiseDrownedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

