/*
 * Decompiled with CFR 0.152.
 */
package net.mde.duneons.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mde.duneons.client.model.Modelsoul;
import net.mde.duneons.client.model.animations.soulAnimation;
import net.mde.duneons.entity.SoulEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class SoulRenderer
extends MobRenderer<SoulEntity, Modelsoul<SoulEntity>> {
    public SoulRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelsoul.LAYER_LOCATION)), 0.0f);
        this.addLayer((RenderLayer)new RenderLayer<SoulEntity, Modelsoul<SoulEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"duneons:textures/entities/soul.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, SoulEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                Modelsoul model = new Modelsoul(Minecraft.getInstance().getEntityModels().bakeLayer(Modelsoul.LAYER_LOCATION));
                ((Modelsoul)this.getParentModel()).copyPropertiesTo(model);
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            }
        });
    }

    public ResourceLocation getTextureLocation(SoulEntity entity) {
        return ResourceLocation.parse((String)"duneons:textures/entities/null_mob.png");
    }

    private static final class AnimatedModel
    extends Modelsoul<SoulEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<SoulEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(SoulEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, soulAnimation.idle, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(SoulEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

